/*
 * Decompiled with CFR 0.152.
 */
package org.chenile.utils.tenancy;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.chenile.base.exception.ServerException;
import org.chenile.utils.str.StrSubstitutor;
import org.chenile.utils.tenancy.CachedValue;
import org.chenile.utils.tenancy.Key;

public class TenantSpecificResourceLoader {
    public String delimiter = "%";
    protected String tenantSpecificPath;
    protected String genericPath;
    protected Map<Key, CachedValue> templateStore = new HashMap<Key, CachedValue>();
    protected static final String GENERIC_TENANT_NAME = "__generic__";

    public TenantSpecificResourceLoader(String tenantSpecificPath, String genericPath) {
        this.tenantSpecificPath = tenantSpecificPath;
        this.genericPath = genericPath;
    }

    public URL obtainURL(String name, String tenantId) {
        CachedValue value = this.obtainValue(name, tenantId);
        return value.url;
    }

    public String obtainFileName(String name, String tenantId) {
        CachedValue value = this.obtainValue(name, tenantId);
        return value.fileName;
    }

    protected CachedValue obtainValue(String name, String tenantId) {
        Key key = new Key();
        key.name = name;
        key.tenantId = tenantId;
        if (this.templateStore.containsKey(key)) {
            CachedValue value = this.templateStore.get(key);
            return value;
        }
        try {
            CachedValue value = this.lookup(key);
            this.templateStore.put(key, value);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected CachedValue lookup(Key key) throws Exception {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("tenantId", key.tenantId);
        valueMap.put("name", key.name);
        String filename = StrSubstitutor.replaceNamedKeysInTemplate(this.tenantSpecificPath, valueMap, this.delimiter);
        URL res = this.getClass().getClassLoader().getResource(filename);
        if (res == null) {
            Key genericKey = new Key();
            genericKey.name = key.name;
            genericKey.tenantId = GENERIC_TENANT_NAME;
            CachedValue genericValue = this.templateStore.get(genericKey);
            if (genericValue != null) {
                return genericValue;
            }
            filename = StrSubstitutor.replaceNamedKeysInTemplate(this.genericPath, valueMap, this.delimiter);
            res = this.getClass().getClassLoader().getResource(filename);
            if (res == null) {
                throw new ServerException(601, "Class " + this.getClass().getName() + ": Unable to find a default template for " + key.name);
            }
            genericValue = this.populateValue(filename, res);
            this.templateStore.put(genericKey, genericValue);
            this.templateStore.put(key, genericValue);
            return genericValue;
        }
        CachedValue value = this.populateValue(filename, res);
        this.templateStore.put(key, value);
        return value;
    }

    protected CachedValue populateValue(String filename, URL url) throws Exception {
        return new CachedValue(url, filename);
    }
}

