/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.database;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import org.chocosolver.solver.ResolutionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLAccess {
    private static final Logger logger = LoggerFactory.getLogger(MySQLAccess.class);
    private static final String SAT = "SAT";
    private static final String MIN = "MIN";
    private static final String MAX = "MAX";
    private Properties properties = new Properties();
    private final String url;
    private final String dbname;
    private final String user;
    private final String pwd;
    private Connection connection;
    private PreparedStatement statement;
    private ResultSet resultSet;

    public MySQLAccess(File mysqlProperties) {
        try {
            this.properties.load(new FileInputStream(mysqlProperties));
        }
        catch (Exception e) {
            logger.error("Unable to load " + mysqlProperties + " file from classpath.", e);
            System.exit(1);
        }
        this.url = this.properties.getProperty("mysql.url");
        this.dbname = this.properties.getProperty("mysql.dbname");
        this.user = this.properties.getProperty("mysql.user");
        this.pwd = this.properties.getProperty("mysql.pwd");
    }

    public void connect() {
        if (this.connection == null) {
            try {
                Class.forName("com.mysql.jdbc.Driver").newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            try {
                this.connection = DriverManager.getConnection("jdbc:mysql://" + this.url + "/" + this.dbname, this.user, this.pwd);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void insert(String filename, String benchname, Number[] measures, ResolutionPolicy policy, boolean isFeasible, boolean isopt) {
        try {
            File instance = new File(filename);
            String name = instance.getName();
            boolean optpb = policy != ResolutionPolicy.SATISFACTION;
            int bid = this.getBenchID(benchname);
            int pid = this.getPbID(name, policy, optpb ? measures[5].longValue() : measures[0].longValue(), optpb ? isopt : isFeasible);
            this.insertData(optpb, measures, bid, pid);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void insertData(boolean optpb, Number[] measures, int bid, int pid) {
        try {
            this.statement = this.connection.prepareStatement("insert into RESOLUTIONS values (?, ?, ?, ?, ?, ?, ?, ?)");
            this.statement.setInt(1, bid);
            this.statement.setInt(2, pid);
            this.statement.setLong(3, measures[1].longValue());
            this.statement.setLong(4, measures[4].longValue());
            long obj = -100L;
            if (optpb) {
                if (measures[0].longValue() > 0L) {
                    obj = measures[5].intValue();
                }
            } else {
                obj = measures[0].longValue();
            }
            this.statement.setLong(5, obj);
            this.statement.setLong(6, measures[0].longValue());
            this.statement.setLong(7, measures[7].longValue());
            this.statement.setLong(8, measures[9].longValue());
            this.statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int getBenchID(String benchname) throws SQLException {
        this.statement = this.connection.prepareStatement("select BID from BENCHMARKS where NAME = ?;");
        this.statement.setString(1, benchname);
        this.resultSet = this.statement.executeQuery();
        if (this.resultSet.next()) {
            return this.resultSet.getInt(1);
        }
        this.statement = this.connection.prepareStatement("insert into BENCHMARKS (NAME, DATE, SID) values (?,?,?);");
        this.statement.setString(1, benchname);
        Date today = new Date();
        java.sql.Date sqlToday = new java.sql.Date(today.getTime());
        this.statement.setDate(2, sqlToday);
        this.statement.setInt(3, 1);
        this.statement.executeUpdate();
        return this.getBenchID(benchname);
    }

    private int getPbID(String filename, ResolutionPolicy policy, long solution, boolean isopt) throws SQLException {
        this.statement = this.connection.prepareStatement("select PID from PROBLEMS where NAME = ?;");
        this.statement.setString(1, filename);
        this.resultSet = this.statement.executeQuery();
        if (this.resultSet.next()) {
            return this.resultSet.getInt(1);
        }
        this.statement = this.connection.prepareStatement("insert into PROBLEMS (NAME, RESOLUTION, OBJECTIVE, OPTIMAL) values (?,?,?,?);");
        this.statement.setString(1, filename);
        switch (policy) {
            case SATISFACTION: {
                this.statement.setString(2, SAT);
                break;
            }
            case MINIMIZE: {
                this.statement.setString(2, MIN);
                break;
            }
            case MAXIMIZE: {
                this.statement.setString(2, MAX);
            }
        }
        this.statement.setLong(3, solution == Integer.MAX_VALUE ? -100L : solution);
        this.statement.setBoolean(4, isopt);
        this.statement.executeUpdate();
        return this.getPbID(filename, policy, solution, isopt);
    }
}

