/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory;

import java.io.Serializable;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;

public abstract class IStateDoubleVector
implements Serializable {
    public static final int MIN_CAPACITY = 8;
    protected double[] elementData;
    protected IStateInt size;
    protected final IEnvironment environment;

    protected IStateDoubleVector(IEnvironment env, int initialSize, double initialValue) {
        int initialCapacity = 8;
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new double[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.elementData[i] = initialValue;
        }
        this.size = env.makeInt(initialSize);
    }

    protected IStateDoubleVector(IEnvironment env, double[] entries) {
        int initialCapacity = 8;
        int initialSize = entries.length;
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new double[initialCapacity];
        System.arraycopy(entries, 0, this.elementData, 0, initialSize);
        this.size = env.makeInt(initialSize);
    }

    public final int size() {
        return this.size.get();
    }

    public final boolean isEmpty() {
        return this.size.get() == 0;
    }

    public abstract void add(double var1);

    public abstract void remove(int var1);

    public abstract void removeLast();

    public final double get(int index) {
        if (this.rangeCheck(index)) {
            return this.elementData[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    public final double quickGet(int index) {
        assert (this.rangeCheck(index));
        return this.elementData[index];
    }

    protected boolean rangeCheck(int index) {
        return index < this.size.get() && index >= 0;
    }

    public abstract double set(int var1, double var2);

    public abstract double quickSet(int var1, double var2);

    public double[] deepCopy() {
        double[] ret = new double[this.size.get()];
        System.arraycopy(this.elementData, 0, ret, 0, this.size.get());
        return ret;
    }
}

