/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.copy;

import org.chocosolver.memory.AbstractEnvironment;
import org.chocosolver.memory.IStateBool;
import org.chocosolver.memory.IStateDouble;
import org.chocosolver.memory.IStateDoubleVector;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.memory.IStateIntVector;
import org.chocosolver.memory.IStateLong;
import org.chocosolver.memory.IStorage;
import org.chocosolver.memory.copy.RcBool;
import org.chocosolver.memory.copy.RcDouble;
import org.chocosolver.memory.copy.RcDoubleVector;
import org.chocosolver.memory.copy.RcInt;
import org.chocosolver.memory.copy.RcIntVector;
import org.chocosolver.memory.copy.RcLong;
import org.chocosolver.memory.copy.store.IStoredBoolCopy;
import org.chocosolver.memory.copy.store.IStoredDoubleCopy;
import org.chocosolver.memory.copy.store.IStoredIntCopy;
import org.chocosolver.memory.copy.store.IStoredLongCopy;
import org.chocosolver.memory.copy.store.StoredBoolCopy;
import org.chocosolver.memory.copy.store.StoredDoubleCopy;
import org.chocosolver.memory.copy.store.StoredDoubleVectorCopy;
import org.chocosolver.memory.copy.store.StoredIntCopy;
import org.chocosolver.memory.copy.store.StoredIntVectorCopy;
import org.chocosolver.memory.copy.store.StoredLongCopy;
import org.chocosolver.memory.copy.store.StoredObjectCopy;
import org.chocosolver.memory.copy.store.StoredOperationCopy;
import org.chocosolver.memory.structure.Operation;

public class EnvironmentCopying
extends AbstractEnvironment {
    private IStoredBoolCopy boolCopy;
    private IStoredIntCopy intCopy;
    private IStoredLongCopy longCopy;
    private IStoredDoubleCopy doubleCopy;
    private StoredOperationCopy operationCopy;
    private StoredIntVectorCopy intVectorCopy;
    private StoredDoubleVectorCopy doubleVectorCopy;
    private StoredObjectCopy objectCopy;
    private IStorage[] copies = new IStorage[0];
    private int copySize = 0;

    public EnvironmentCopying() {
        super(AbstractEnvironment.Type.FLAT);
    }

    @Override
    public void worldPush() {
        int wi = this.currentWorld + 1;
        for (int i = 0; i < this.copySize; ++i) {
            this.copies[i].worldPush(wi);
        }
        ++this.currentWorld;
    }

    @Override
    public void worldPop() {
        int wi = this.currentWorld;
        for (int i = this.copySize - 1; i >= 0; --i) {
            this.copies[i].worldPop(wi);
        }
        --this.currentWorld;
    }

    @Override
    public void worldPopUntil(int w) {
        for (int i = this.copySize - 1; i >= 0; --i) {
            this.copies[i].worldPop(w);
        }
        this.currentWorld = w;
    }

    @Override
    public void save(Operation operation) {
        this.getOperationCopy().savePreviousState(operation);
    }

    @Override
    public void worldCommit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStateInt makeInt() {
        return new RcInt(this, 0);
    }

    @Override
    public IStateInt makeInt(int initialValue) {
        return new RcInt(this, initialValue);
    }

    @Override
    public IStateBool makeBool(boolean initialValue) {
        return new RcBool(this, initialValue);
    }

    @Override
    public IStateIntVector makeIntVector(int size, int initialValue) {
        return new RcIntVector(this, size, initialValue);
    }

    @Override
    public IStateDoubleVector makeDoubleVector(int size, double initialValue) {
        return new RcDoubleVector(this, size, initialValue);
    }

    @Override
    public IStateDouble makeFloat() {
        return new RcDouble(this);
    }

    @Override
    public IStateDouble makeFloat(double initialValue) {
        return new RcDouble(this, initialValue);
    }

    @Override
    public IStateLong makeLong() {
        return new RcLong(this);
    }

    @Override
    public IStateLong makeLong(long init) {
        return new RcLong(this, init);
    }

    private void increaseCopy() {
        IStorage[] tmp = this.copies;
        this.copies = new IStorage[tmp.length + 1];
        System.arraycopy(tmp, 0, this.copies, 0, tmp.length);
    }

    public IStoredIntCopy getIntCopy() {
        if (this.intCopy == null) {
            switch (this.type) {
                case FLAT: {
                    this.intCopy = new StoredIntCopy();
                }
            }
            this.increaseCopy();
            this.copies[this.copySize++] = this.intCopy;
        }
        return this.intCopy;
    }

    public IStoredLongCopy getLongCopy() {
        if (this.longCopy == null) {
            switch (this.type) {
                case FLAT: {
                    this.longCopy = new StoredLongCopy();
                }
            }
            this.increaseCopy();
            this.copies[this.copySize++] = this.longCopy;
        }
        return this.longCopy;
    }

    public IStoredBoolCopy getBoolCopy() {
        if (this.boolCopy == null) {
            switch (this.type) {
                case FLAT: {
                    this.boolCopy = new StoredBoolCopy();
                }
            }
            this.increaseCopy();
            this.copies[this.copySize++] = this.boolCopy;
        }
        return this.boolCopy;
    }

    public IStoredDoubleCopy getDoubleCopy() {
        if (this.doubleCopy == null) {
            switch (this.type) {
                case FLAT: {
                    this.doubleCopy = new StoredDoubleCopy();
                }
            }
            this.increaseCopy();
            this.copies[this.copySize++] = this.doubleCopy;
        }
        return this.doubleCopy;
    }

    public StoredOperationCopy getOperationCopy() {
        if (this.operationCopy == null) {
            switch (this.type) {
                case FLAT: {
                    this.operationCopy = new StoredOperationCopy();
                }
            }
            this.increaseCopy();
            this.copies[this.copySize++] = this.operationCopy;
        }
        return this.operationCopy;
    }

    public StoredIntVectorCopy getIntVectorCopy() {
        if (this.intVectorCopy == null) {
            this.intVectorCopy = new StoredIntVectorCopy(this.currentWorld);
            this.increaseCopy();
            this.copies[this.copySize++] = this.intVectorCopy;
        }
        return this.intVectorCopy;
    }

    public StoredDoubleVectorCopy getDoubleVectorCopy() {
        if (this.doubleVectorCopy == null) {
            this.doubleVectorCopy = new StoredDoubleVectorCopy(this.currentWorld);
            this.increaseCopy();
            this.copies[this.copySize++] = this.doubleVectorCopy;
        }
        return this.doubleVectorCopy;
    }

    public StoredObjectCopy getObjectCopy() {
        if (this.objectCopy == null) {
            this.objectCopy = new StoredObjectCopy(this.currentWorld);
            this.increaseCopy();
            this.copies[this.copySize++] = this.objectCopy;
        }
        return this.objectCopy;
    }
}

