/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.copy;

import org.chocosolver.memory.IStateIntVector;
import org.chocosolver.memory.copy.EnvironmentCopying;

public final class RcIntVector
extends IStateIntVector {
    private int timeStamp;

    public RcIntVector(EnvironmentCopying env, int initialSize, int initialValue) {
        super(env, initialSize, initialValue);
        this.timeStamp = this.environment.getWorldIndex();
        env.getIntVectorCopy().add(this);
    }

    public RcIntVector(EnvironmentCopying env, int[] entries) {
        super(env, entries);
        env.getIntVectorCopy().add(this);
        this.timeStamp = this.environment.getWorldIndex();
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size.get());
        }
    }

    @Override
    public void add(int i) {
        this.timeStamp = this.environment.getWorldIndex();
        int newsize = this.size.get() + 1;
        this.ensureCapacity(newsize);
        this.size.set(newsize);
        this.elementData[newsize - 1] = i;
    }

    @Override
    public void removeLast() {
        this.timeStamp = this.environment.getWorldIndex();
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    @Override
    public int set(int index, int val) {
        if (index < this.size.get() && index >= 0) {
            int oldValue = this.elementData[index];
            if (val != oldValue) {
                this.elementData[index] = val;
            }
            this.timeStamp = this.environment.getWorldIndex();
            return oldValue;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public int quickSet(int index, int val) {
        int oldValue = this.elementData[index];
        if (val != oldValue) {
            this.elementData[index] = val;
        }
        this.timeStamp = this.environment.getWorldIndex();
        return oldValue;
    }

    @Override
    public void remove(int i) {
    }

    public void _set(int[] vals) {
        this.timeStamp = this.environment.getWorldIndex();
        System.arraycopy(vals, 0, this.elementData, 0, vals.length);
    }

    public void _set(int[] vals, int timeStamp) {
        this.timeStamp = timeStamp;
        System.arraycopy(vals, 0, this.elementData, 0, vals.length);
    }

    public int getTimeStamp() {
        return this.timeStamp;
    }
}

