/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.copy.store;

import org.chocosolver.memory.copy.RcBool;
import org.chocosolver.memory.copy.store.IStoredBoolCopy;

public class StoredBoolCopy
implements IStoredBoolCopy {
    RcBool[] objects = new RcBool[64];
    boolean[][] values = new boolean[64][];
    int position;

    @Override
    public void add(RcBool rc) {
        if (this.position == this.objects.length) {
            int newSize = this.objects.length * 3 / 2 + 1;
            RcBool[] oldElements = this.objects;
            this.objects = new RcBool[newSize];
            System.arraycopy(oldElements, 0, this.objects, 0, oldElements.length);
        }
        this.objects[this.position++] = rc;
    }

    @Override
    public void worldPush(int worldIndex) {
        if (this.values.length <= worldIndex) {
            boolean[][] tmp = this.values;
            this.values = new boolean[tmp.length * 3 / 2 + 1][];
            System.arraycopy(tmp, 0, this.values, 0, tmp.length);
        }
        boolean[] tmpboolean = new boolean[this.position];
        int i = this.position;
        while (--i >= 0) {
            tmpboolean[i] = this.objects[i].deepCopy();
        }
        this.values[worldIndex] = tmpboolean;
    }

    @Override
    public void worldPop(int worldIndex) {
        boolean[] tmpboolean = this.values[worldIndex];
        int i = tmpboolean.length;
        while (--i >= 0) {
            this.objects[i]._set(tmpboolean[i], worldIndex);
        }
    }

    @Override
    public void worldCommit(int worldIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void buildFakeHistory(RcBool v, boolean initValue, int olderStamp) {
        for (int i = 1; i <= olderStamp; ++i) {
            boolean[] _values = this.values[i];
            int size = _values.length;
            this.values[i] = new boolean[this.position];
            System.arraycopy(_values, 0, this.values[i], 0, size);
            this.values[i][size] = initValue;
        }
    }
}

