/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.copy.store;

import org.chocosolver.memory.copy.RcDouble;
import org.chocosolver.memory.copy.store.IStoredDoubleCopy;

public class StoredDoubleCopy
implements IStoredDoubleCopy {
    RcDouble[] objects = new RcDouble[64];
    double[][] values = new double[64][];
    int position;

    @Override
    public void add(RcDouble rc) {
        if (this.position == this.objects.length) {
            int newSize = this.objects.length * 3 / 2 + 1;
            RcDouble[] oldElements = this.objects;
            this.objects = new RcDouble[newSize];
            System.arraycopy(oldElements, 0, this.objects, 0, oldElements.length);
        }
        this.objects[this.position++] = rc;
    }

    @Override
    public void worldPush(int worldIndex) {
        if (this.values.length <= worldIndex) {
            double[][] tmp = this.values;
            this.values = new double[tmp.length * 3 / 2 + 1][];
            System.arraycopy(tmp, 0, this.values, 0, tmp.length);
        }
        double[] tmpdouble = new double[this.position];
        int i = this.position;
        while (--i >= 0) {
            tmpdouble[i] = this.objects[i].deepCopy();
        }
        this.values[worldIndex] = tmpdouble;
    }

    @Override
    public void worldPop(int worldIndex) {
        double[] tmpdouble = this.values[worldIndex];
        int i = tmpdouble.length;
        while (--i >= 0) {
            this.objects[i]._set(tmpdouble[i], worldIndex);
        }
    }

    @Override
    public void worldCommit(int worldIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void buildFakeHistory(RcDouble v, double initValue, int olderStamp) {
        for (int i = 1; i <= olderStamp; ++i) {
            double[] _values = this.values[i];
            int size = _values.length;
            this.values[i] = new double[this.position];
            System.arraycopy(_values, 0, this.values[i], 0, size);
            this.values[i][size] = initValue;
        }
    }
}

