/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.copy.store;

import org.chocosolver.memory.copy.RcInt;
import org.chocosolver.memory.copy.store.IStoredIntCopy;

public class StoredIntCopy
implements IStoredIntCopy {
    RcInt[] objects = new RcInt[64];
    int[][] values = new int[64][];
    int position;

    @Override
    public void add(RcInt rc) {
        if (this.position == this.objects.length) {
            int newSize = this.objects.length * 3 / 2 + 1;
            RcInt[] oldElements = this.objects;
            this.objects = new RcInt[newSize];
            System.arraycopy(oldElements, 0, this.objects, 0, oldElements.length);
        }
        this.objects[this.position++] = rc;
    }

    @Override
    public void worldPush(int worldIndex) {
        if (this.values.length <= worldIndex) {
            int[][] tmp = this.values;
            this.values = new int[tmp.length * 3 / 2 + 1][];
            System.arraycopy(tmp, 0, this.values, 0, tmp.length);
        }
        int[] tmpint = new int[this.position];
        int i = this.position;
        while (--i >= 0) {
            tmpint[i] = this.objects[i].deepCopy();
        }
        this.values[worldIndex] = tmpint;
    }

    @Override
    public void worldPop(int worldIndex) {
        int[] tmpint = this.values[worldIndex];
        int i = tmpint.length;
        while (--i >= 0) {
            this.objects[i]._set(tmpint[i], worldIndex);
        }
    }

    @Override
    public void worldCommit(int worldIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void buildFakeHistory(RcInt v, int initValue, int olderStamp) {
        for (int i = 1; i <= olderStamp; ++i) {
            int[] _values = this.values[i];
            int size = _values.length;
            this.values[i] = new int[this.position];
            System.arraycopy(_values, 0, this.values[i], 0, size);
            this.values[i][size] = initValue;
        }
    }
}

