/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.copy.store;

import org.chocosolver.memory.IStorage;
import org.chocosolver.memory.copy.RcIntVector;

public class StoredIntVectorCopy
implements IStorage {
    RcIntVector[] objects = new RcIntVector[64];
    int[][][] values;
    int position;
    int lastSavedWorldIndex;

    public StoredIntVectorCopy(int worldIndex) {
        this.lastSavedWorldIndex = worldIndex;
    }

    public void add(RcIntVector rc) {
        if (this.position == this.objects.length) {
            int newSize = this.objects.length * 3 / 2 + 1;
            RcIntVector[] oldElements = this.objects;
            this.objects = new RcIntVector[newSize];
            System.arraycopy(oldElements, 0, this.objects, 0, oldElements.length);
        }
        this.objects[this.position++] = rc;
    }

    @Override
    public void worldPush(int worldIndex) {
        if (this.lastSavedWorldIndex >= worldIndex) {
            this.lastSavedWorldIndex = 0;
        }
        if (this.values.length >= worldIndex) {
            int[][][] tmp = this.values;
            this.values = new int[worldIndex * 3 / 2 + 1][][];
            System.arraycopy(tmp, 0, this.values, 0, worldIndex - 1);
        }
        int[][] tmpint = new int[this.objects.length][];
        int i = this.objects.length;
        while (--i >= 0) {
            if (worldIndex != 0 && this.lastSavedWorldIndex >= this.objects[i].getTimeStamp()) {
                tmpint[i] = this.values[this.lastSavedWorldIndex][i];
                continue;
            }
            tmpint[i] = this.objects[i].deepCopy();
        }
        this.values[worldIndex] = tmpint;
    }

    @Override
    public void worldPop(int worldIndex) {
        int[][] tmpobj = this.values[worldIndex];
        int i = tmpobj.length;
        while (--i >= 0) {
            this.objects[i]._set(tmpobj[i], worldIndex);
        }
    }

    @Override
    public void worldCommit(int worldIndex) {
        throw new UnsupportedOperationException();
    }
}

