/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.copy.store;

import org.chocosolver.memory.copy.RcLong;
import org.chocosolver.memory.copy.store.IStoredLongCopy;

public class StoredLongCopy
implements IStoredLongCopy {
    RcLong[] objects = new RcLong[64];
    long[][] values = new long[64][];
    int position;

    @Override
    public void add(RcLong rc) {
        if (this.position == this.objects.length) {
            int newSize = this.objects.length * 3 / 2 + 1;
            RcLong[] oldElements = this.objects;
            this.objects = new RcLong[newSize];
            System.arraycopy(oldElements, 0, this.objects, 0, oldElements.length);
        }
        this.objects[this.position++] = rc;
    }

    @Override
    public void worldPush(int worldIndex) {
        if (this.values.length <= worldIndex) {
            long[][] tmp = this.values;
            this.values = new long[tmp.length * 3 / 2 + 1][];
            System.arraycopy(tmp, 0, this.values, 0, tmp.length);
        }
        long[] tmplong = new long[this.position];
        int i = this.position;
        while (--i >= 0) {
            tmplong[i] = this.objects[i].deepCopy();
        }
        this.values[worldIndex] = tmplong;
    }

    @Override
    public void worldPop(int worldIndex) {
        long[] tmplong = this.values[worldIndex];
        int i = tmplong.length;
        while (--i >= 0) {
            this.objects[i]._set(tmplong[i], worldIndex);
        }
    }

    @Override
    public void worldCommit(int worldIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void buildFakeHistory(RcLong v, long initValue, int olderStamp) {
        for (int i = 1; i <= olderStamp; ++i) {
            long[] _values = this.values[i];
            int size = _values.length;
            this.values[i] = new long[this.position];
            System.arraycopy(_values, 0, this.values[i], 0, size);
            this.values[i][size] = initValue;
        }
    }
}

