/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.copy.store;

import org.chocosolver.memory.IStorage;
import org.chocosolver.memory.copy.RcObject;

public class StoredObjectCopy
implements IStorage {
    RcObject[] objects = new RcObject[64];
    Object[][] values;
    int position;
    int lastSavedWorldIndex;

    public StoredObjectCopy(int worldIndex) {
        this.lastSavedWorldIndex = worldIndex;
    }

    public void add(RcObject rc) {
        if (this.position == this.objects.length) {
            int newSize = this.objects.length * 3 / 2 + 1;
            RcObject[] oldElements = this.objects;
            this.objects = new RcObject[newSize];
            System.arraycopy(oldElements, 0, this.objects, 0, oldElements.length);
        }
        this.objects[this.position++] = rc;
    }

    @Override
    public void worldPush(int worldIndex) {
        if (this.lastSavedWorldIndex >= worldIndex) {
            this.lastSavedWorldIndex = 0;
        }
        if (this.values.length >= worldIndex) {
            Object[][] tmp = this.values;
            this.values = new Object[worldIndex * 3 / 2 + 1][];
            System.arraycopy(tmp, 0, this.values, 0, worldIndex - 1);
        }
        Object[] tmpobj = new Object[this.objects.length];
        int i = this.objects.length;
        while (--i >= 0) {
            if (worldIndex != 0 && this.lastSavedWorldIndex >= this.objects[i].getTimeStamp()) {
                tmpobj[i] = this.values[this.lastSavedWorldIndex][i];
                continue;
            }
            tmpobj[i] = this.objects[i].deepCopy();
        }
        this.values[worldIndex] = tmpobj;
    }

    @Override
    public void worldPop(int worldIndex) {
        Object[] tmpobj = this.values[worldIndex];
        int i = tmpobj.length;
        while (--i >= 0) {
            this.objects[i]._set(tmpobj[i], worldIndex);
        }
    }

    @Override
    public void worldCommit(int worldIndex) {
        throw new UnsupportedOperationException();
    }
}

