/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.copy.store;

import org.chocosolver.memory.IStorage;
import org.chocosolver.memory.structure.Operation;

public class StoredOperationCopy
implements IStorage {
    private Operation[] valueStack = new Operation[64];
    private int currentLevel = 0;
    private int[] worldStartLevels = new int[64];

    @Override
    public void worldPush(int worldIndex) {
        if (worldIndex == this.worldStartLevels.length) {
            int[] tmp = new int[worldIndex * 3 / 2 + 1];
            System.arraycopy(this.worldStartLevels, 0, tmp, 0, this.worldStartLevels.length);
            this.worldStartLevels = tmp;
        }
        this.worldStartLevels[worldIndex] = this.currentLevel;
    }

    @Override
    public void worldPop(int worldIndex) {
        int wsl = this.worldStartLevels[worldIndex];
        while (this.currentLevel > wsl) {
            --this.currentLevel;
            this.valueStack[this.currentLevel].undo();
        }
    }

    @Override
    public void worldCommit(int worldIndex) {
    }

    public void savePreviousState(Operation oldValue) {
        this.valueStack[this.currentLevel] = oldValue;
        ++this.currentLevel;
        if (this.currentLevel == this.valueStack.length) {
            this.resizeUpdateCapacity();
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = this.valueStack.length * 3 / 2;
        Operation[] tmp2 = new Operation[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
    }
}

