/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.structure;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;

public final class BasicIndexedBipartiteSet {
    protected int[] list;
    protected int[] position;
    protected IStateInt first;
    protected int size;

    public BasicIndexedBipartiteSet(IEnvironment environment, int nbValues) {
        this.list = new int[nbValues];
        this.position = new int[nbValues];
        for (int i = 0; i < nbValues; ++i) {
            this.list[i] = this.position[i] = i;
        }
        this.first = environment.makeInt(0);
        this.size = 0;
    }

    private void increaseSize() {
        int nexSize = this.list.length * 3 / 2;
        int[] list_ = this.list;
        this.list = new int[nexSize];
        System.arraycopy(list_, 0, this.list, 0, list_.length);
        int[] position_ = this.position;
        this.position = new int[nexSize];
        System.arraycopy(position_, 0, this.position, 0, position_.length);
    }

    public final int size() {
        return this.size - this.first.get() + 1;
    }

    public final boolean isEmpty() {
        return this.first.get() == this.size;
    }

    public final int add() {
        if (this.list.length == this.size) {
            this.increaseSize();
        }
        this.list[this.size] = this.size;
        this.position[this.list[this.size]] = this.size;
        ++this.size;
        return this.size - 1;
    }

    public void swap(int object) {
        int idxToSwap = this.position[object];
        if (idxToSwap == this.first.get()) {
            this.first.add(1);
        } else {
            int temp = this.list[this.first.get()];
            this.list[this.first.get()] = object;
            this.list[idxToSwap] = temp;
            this.position[object] = this.first.get();
            this.position[temp] = idxToSwap;
            this.first.add(1);
        }
    }

    public int get(int index) {
        return this.list[index];
    }

    public boolean bundle(int i) {
        return this.position[i] >= this.first.get();
    }

    public boolean contains(int i) {
        return this.bundle(i);
    }
}

