/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.structure;

import org.chocosolver.memory.EnvironmentException;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.memory.IStateIntVector;

public class IndexedBipartiteSet
extends IStateIntVector {
    protected int[] list;
    protected int[] position;
    protected IStateInt last;

    public void buildList(IEnvironment environment, int[] values) {
        int i;
        this.list = values;
        int maxElt = 0;
        for (i = 0; i < values.length; ++i) {
            if (values[i] <= maxElt) continue;
            maxElt = values[i];
        }
        this.position = new int[maxElt + 1];
        for (i = 0; i < values.length; ++i) {
            this.position[values[i]] = i;
        }
        this.last = environment.makeInt(this.list.length - 1);
    }

    public IndexedBipartiteSet(IEnvironment environment, int nbValues) {
        super(environment);
        int[] values = new int[nbValues];
        for (int i = 0; i < nbValues; ++i) {
            values[i] = i;
        }
        this.buildList(environment, values);
    }

    public IndexedBipartiteSet(IEnvironment environment, int[] values) {
        super(environment);
        this.buildList(environment, values);
    }

    public final void increaseSize(int gap) {
        int l = this.list.length;
        int[] newList = new int[l + gap];
        for (int i = 0; i < l + gap; ++i) {
            newList[i] = i;
        }
        int maxElt = 0;
        for (int i = 0; i < newList.length; ++i) {
            if (newList[i] <= maxElt) continue;
            maxElt = newList[i];
        }
        int[] newPosition = new int[maxElt + 1];
        for (int i = 0; i < newList.length; ++i) {
            newPosition[newList[i]] = i;
        }
        int end = this.last.get() + 1;
        int[] removed = new int[this.list.length - end];
        System.arraycopy(this.list, end, removed, 0, this.list.length - end);
        this.list = newList;
        this.position = newPosition;
        IEnvironment env = this.last.getEnvironment();
        this.last = null;
        this.last = env.makeInt(this.list.length - 1);
        for (int i = 0; i < removed.length; ++i) {
            this.remove(removed[i]);
        }
    }

    @Override
    public final int size() {
        return this.last.get() + 1;
    }

    @Override
    public final boolean isEmpty() {
        return this.last.get() == -1;
    }

    @Override
    public final void add(int i) {
        throw new UnsupportedOperationException("adding element is not permitted in this structure (the list is only meant to decrease during search)");
    }

    public final void clear() {
        this.last.set(-1);
    }

    @Override
    public final void removeLast() {
        this.remove(this.list[this.last.get()]);
    }

    @Override
    public void remove(int object) {
        if (this.contains(object)) {
            int idxToRem = this.position[object];
            if (idxToRem == this.last.get()) {
                this.last.add(-1);
            } else {
                int temp = this.list[this.last.get()];
                this.list[this.last.get()] = object;
                this.list[idxToRem] = temp;
                this.position[object] = this.last.get();
                this.position[temp] = idxToRem;
                this.last.add(-1);
            }
        }
    }

    @Override
    public boolean contains(int object) {
        return object >= 0 && object < this.position.length && this.position[object] <= this.last.get();
    }

    @Override
    public final int get(int index) {
        return this.list[index];
    }

    @Override
    public final int quickGet(int index) {
        return this.get(index);
    }

    @Override
    public final int set(int index, int val) {
        throw new EnvironmentException("setting an element is not permitted on this structure");
    }

    @Override
    public final int quickSet(int index, int val) {
        return this.set(index, val);
    }

    public final String pretty() {
        StringBuilder s = new StringBuilder("[");
        for (int i = 0; i <= this.last.get(); ++i) {
            s.append(this.list[i]).append(i == this.last.get() ? "" : ",");
        }
        return s.append(']').toString();
    }

    public final int findIndexOfInt(int a) {
        return this.list.length - this.position[a];
    }
}

