/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.structure;

import java.lang.reflect.Array;
import java.util.BitSet;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.IStateInt;

public class OneWordS32BitSet
implements IStateBitSet {
    private static final int ADDRESS_BITS_PER_WORD = 5;
    private static final int BITS_PER_WORD = 32;
    private static final int WORD_MASK = -1;
    private final IEnvironment environment;
    private IStateInt word;

    public OneWordS32BitSet(IEnvironment environment) {
        this.environment = environment;
        this.word = this.environment.makeInt(0);
    }

    public OneWordS32BitSet(IEnvironment environment, int nbits) {
        this.environment = environment;
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        if (nbits > 32) {
            throw new ArrayIndexOutOfBoundsException("nbits > 32: " + nbits);
        }
        this.word = this.environment.makeInt(0);
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return OneWordS32BitSet.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    @Override
    public BitSet copyToBitSet() {
        BitSet view = new BitSet(this.size());
        int i = this.nextSetBit(0);
        while (i >= 0) {
            view.set(i, true);
            i = this.nextSetBit(i + 1);
        }
        return view;
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    @Override
    public void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int tmp = this.word.get();
        this.word.set(tmp ^= 1 << bitIndex);
    }

    @Override
    public void flip(int fromIndex, int toIndex) {
        OneWordS32BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        int tmp = this.word.get();
        this.word.set(tmp ^= firstWordMask & lastWordMask);
    }

    @Override
    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.word.set(this.word.get() | 1 << bitIndex);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        OneWordS32BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        this.word.set(this.word.get() | firstWordMask & lastWordMask);
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    @Override
    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.word.set(this.word.get() & ~(1 << bitIndex));
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        OneWordS32BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        this.word.set(this.word.get() & ~(firstWordMask & lastWordMask));
    }

    @Override
    public void clear() {
        this.word.set(0);
    }

    @Override
    public final boolean get(int bitIndex) {
        return bitIndex < 32 && (this.word.get() & 1 << bitIndex) != 0;
    }

    public OneWordS32BitSet get(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= 32) {
            return -1;
        }
        int word = this.word.get() & -1 << fromIndex;
        if (word != 0) {
            return Integer.numberOfTrailingZeros(word);
        }
        return -1;
    }

    @Override
    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= 32) {
            return fromIndex;
        }
        int word = ~this.word.get() & -1 << fromIndex;
        if (word != 0) {
            return Integer.numberOfTrailingZeros(word);
        }
        return 0;
    }

    @Override
    public int prevSetBit(int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex >= 32) {
            return this.length() - 1;
        }
        int word = this.word.get() & -1 >>> -(fromIndex + 1);
        if (word != 0) {
            return 31 - Integer.numberOfLeadingZeros(word);
        }
        return -1;
    }

    @Override
    public int prevClearBit(int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex >= 32) {
            return fromIndex;
        }
        int word = ~this.word.get() & -1 >>> -(fromIndex + 1);
        if (word != 0) {
            return 31 - Integer.numberOfLeadingZeros(word);
        }
        return -1;
    }

    @Override
    public int capacity() {
        return 32;
    }

    public int length() {
        return 32 - Integer.numberOfLeadingZeros(this.word.get());
    }

    @Override
    public boolean isEmpty() {
        return this.word.get() == 0;
    }

    @Override
    public int cardinality() {
        return Integer.bitCount(this.word.get());
    }

    @Override
    public void and(IStateBitSet setI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void or(IStateBitSet setI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void xor(IStateBitSet setI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void andNot(IStateBitSet setI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean intersects(IStateBitSet setI) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int h = 1234;
        return (h ^= this.word.get()) >> 14 ^ h;
    }

    @Override
    public int size() {
        return 32;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OneWordS32BitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        OneWordS32BitSet set = (OneWordS32BitSet)obj;
        return this.word == set.word;
    }

    @Override
    public IStateBitSet copy() {
        OneWordS32BitSet result = new OneWordS32BitSet(this.environment, this.size());
        result.word.set(this.word.get());
        return result;
    }

    public String toString() {
        int numBits = 32;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i < endOfRun);
                i = this.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }
}

