/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.structure;

import java.lang.reflect.Array;
import java.util.BitSet;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.memory.IStateLong;

public class S64BitSet
implements IStateBitSet {
    private static final boolean CHECK = false;
    private static final int ADDRESS_BITS_PER_WORD = 6;
    protected static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    protected static final long WORD_MASK = -1L;
    private final IEnvironment environment;
    protected IStateLong[] words;
    protected final IStateInt wordsInUse;

    protected static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private void checkInvariants() {
        assert (this.wordsInUse.get() == 0 || this.words[this.wordsInUse.get() - 1].get() != 0L);
        assert (this.wordsInUse.get() >= 0 && this.wordsInUse.get() <= this.words.length);
        assert (this.wordsInUse.get() == this.words.length || this.words[this.wordsInUse.get()].get() == 0L);
    }

    private void recalculateWordsInUse() {
        int i;
        int n = this.wordsInUse.get();
        for (i = n - 1; i >= 0 && this.words[i].get() == 0L; --i) {
        }
        if (i + 1 < n) {
            this.wordsInUse.set(i + 1);
        }
    }

    public S64BitSet(IEnvironment environment) {
        this.environment = environment;
        this.wordsInUse = environment.makeInt(0);
        this.initWords(64);
    }

    public S64BitSet(IEnvironment environment, int nbits) {
        this.environment = environment;
        this.wordsInUse = environment.makeInt(0);
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.initWords(nbits);
    }

    private void initWords(int nbits) {
        this.words = new IStateLong[S64BitSet.wordIndex(nbits - 1) + 1];
        for (int i = 0; i < this.words.length; ++i) {
            this.words[i] = this.environment.makeLong(0L);
        }
    }

    public void ensureCapacity(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            int request = Math.max(2 * this.words.length, wordsRequired);
            int oldSize = this.words.length;
            this.words = S64BitSet.copyOf(this.words, request);
            for (int i = oldSize; i < request; ++i) {
                this.words[i] = this.environment.makeLong(0L);
            }
        }
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return S64BitSet.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    @Override
    public BitSet copyToBitSet() {
        BitSet view = new BitSet(this.size());
        int i = this.nextSetBit(0);
        while (i >= 0) {
            view.set(i, true);
            i = this.nextSetBit(i + 1);
        }
        return view;
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse.get() < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse.set(wordsRequired);
        }
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    @Override
    public void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = S64BitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        long tmp = this.words[wordIndex].get();
        this.words[wordIndex].set(tmp ^= 1L << bitIndex);
        this.recalculateWordsInUse();
    }

    @Override
    public void flip(int fromIndex, int toIndex) {
        S64BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = S64BitSet.wordIndex(fromIndex);
        int endWordIndex = S64BitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            long tmp = this.words[startWordIndex].get();
            this.words[startWordIndex].set(tmp ^= firstWordMask & lastWordMask);
        } else {
            this.words[startWordIndex].set(this.words[startWordIndex].get() ^ firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i].set(this.words[i].get() ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.words[endWordIndex].set(this.words[endWordIndex].get() ^ lastWordMask);
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = S64BitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        this.words[wordIndex].set(this.words[wordIndex].get() | 1L << bitIndex);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        S64BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = S64BitSet.wordIndex(fromIndex);
        int endWordIndex = S64BitSet.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.words[startWordIndex].set(this.words[startWordIndex].get() | firstWordMask & lastWordMask);
        } else {
            this.words[startWordIndex].set(this.words[startWordIndex].get() | firstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i].set(-1L);
            }
            this.words[endWordIndex].set(this.words[endWordIndex].get() | lastWordMask);
        }
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    @Override
    public void clear(int bitIndex) {
        int n;
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = S64BitSet.wordIndex(bitIndex);
        if (wordIndex >= (n = this.wordsInUse.get())) {
            return;
        }
        this.words[wordIndex].set(this.words[wordIndex].get() & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL));
        this.recalculateWordsInUse();
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        S64BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int wiu = this.wordsInUse.get();
        int startWordIndex = S64BitSet.wordIndex(fromIndex);
        if (startWordIndex >= wiu) {
            return;
        }
        int endWordIndex = S64BitSet.wordIndex(toIndex - 1);
        if (endWordIndex >= wiu) {
            toIndex = this.length();
            endWordIndex = wiu - 1;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            this.words[startWordIndex].set(this.words[startWordIndex].get() & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
        } else {
            this.words[startWordIndex].set(this.words[startWordIndex].get() & (firstWordMask ^ 0xFFFFFFFFFFFFFFFFL));
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i].set(0L);
            }
            this.words[endWordIndex].set(this.words[endWordIndex].get() & (lastWordMask ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void clear() {
        for (IStateLong word : this.words) {
            word.set(0L);
        }
        this.wordsInUse.set(0);
    }

    @Override
    public final boolean get(int bitIndex) {
        int wordIndex = bitIndex >> 6;
        return wordIndex < this.wordsInUse.get() && (this.words[wordIndex].get() & 1L << bitIndex) != 0L;
    }

    public S64BitSet get(int fromIndex, int toIndex) {
        S64BitSet.checkRange(fromIndex, toIndex);
        int len = this.length();
        if (len <= fromIndex || fromIndex == toIndex) {
            return new S64BitSet(this.environment, 0);
        }
        if (toIndex > len) {
            toIndex = len;
        }
        S64BitSet result = new S64BitSet(this.environment, toIndex - fromIndex);
        int targetWords = S64BitSet.wordIndex(toIndex - fromIndex - 1) + 1;
        int sourceIndex = S64BitSet.wordIndex(fromIndex);
        boolean wordAligned = (fromIndex & 0x3F) == 0;
        int i = 0;
        while (i < targetWords - 1) {
            result.words[i].set(wordAligned ? this.words[sourceIndex].get() : this.words[sourceIndex].get() >>> fromIndex | this.words[sourceIndex + 1].get() << -fromIndex);
            ++i;
            ++sourceIndex;
        }
        long lastWordMask = -1L >>> -toIndex;
        result.words[targetWords - 1].set((toIndex - 1 & 0x3F) < (fromIndex & 0x3F) ? this.words[sourceIndex].get() >>> fromIndex | (this.words[sourceIndex + 1].get() & lastWordMask) << -fromIndex : (this.words[sourceIndex].get() & lastWordMask) >>> fromIndex);
        result.wordsInUse.set(targetWords);
        result.recalculateWordsInUse();
        return result;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int wiu = this.wordsInUse.get();
        int u = S64BitSet.wordIndex(fromIndex);
        if (u >= wiu) {
            return -1;
        }
        long word = this.words[u].get() & -1L << fromIndex;
        while (word == 0L) {
            if (++u == wiu) {
                return -1;
            }
            word = this.words[u].get();
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    @Override
    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int wiu = this.wordsInUse.get();
        int u = S64BitSet.wordIndex(fromIndex);
        if (u >= wiu) {
            return fromIndex;
        }
        long word = (this.words[u].get() ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == wiu) {
                return wiu * 64;
            }
            word = this.words[u].get() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    @Override
    public int prevSetBit(int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        int u = S64BitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse.get()) {
            return this.length() - 1;
        }
        long word = this.words[u].get() & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u].get();
        }
        return (u + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    @Override
    public int prevClearBit(int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        int u = S64BitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse.get()) {
            return fromIndex;
        }
        long word = (this.words[u].get() ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            word = this.words[u].get() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (u + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    @Override
    public int capacity() {
        return this.words.length * 64;
    }

    public int length() {
        int wiu = this.wordsInUse.get();
        if (wiu == 0) {
            return 0;
        }
        return 64 * (wiu - 1) + (64 - Long.numberOfLeadingZeros(this.words[wiu - 1].get()));
    }

    @Override
    public boolean isEmpty() {
        return this.wordsInUse.get() == 0;
    }

    public boolean intersects(S64BitSet set) {
        for (int i = Math.min(this.wordsInUse.get(), set.wordsInUse.get()) - 1; i >= 0; --i) {
            if ((this.words[i].get() & set.words[i].get()) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cardinality() {
        int sum = 0;
        for (int i = this.wordsInUse.get() - 1; i >= 0; --i) {
            sum += Long.bitCount(this.words[i].get());
        }
        return sum;
    }

    @Override
    public void and(IStateBitSet setI) {
        S64BitSet set = (S64BitSet)setI;
        if (this == set) {
            return;
        }
        while (this.wordsInUse.get() > set.wordsInUse.get()) {
            this.wordsInUse.add(-1);
            this.words[this.wordsInUse.get()].set(0L);
        }
        for (int i = 0; i < this.wordsInUse.get(); ++i) {
            this.words[i].set(this.words[i].get() & set.words[i].get());
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void or(IStateBitSet setI) {
        S64BitSet set = (S64BitSet)setI;
        if (this == set) {
            return;
        }
        int wordsInCommon = Math.min(this.wordsInUse.get(), set.wordsInUse.get());
        if (this.wordsInUse.get() < set.wordsInUse.get()) {
            this.ensureCapacity(set.wordsInUse.get());
            this.wordsInUse.set(set.wordsInUse.get());
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            this.words[i].set(this.words[i].get() | set.words[i].get());
        }
        if (wordsInCommon < set.wordsInUse.get()) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, this.wordsInUse.get() - wordsInCommon);
        }
    }

    @Override
    public void xor(IStateBitSet setI) {
        S64BitSet set = (S64BitSet)setI;
        int wordsInCommon = Math.min(this.wordsInUse.get(), set.wordsInUse.get());
        if (this.wordsInUse.get() < set.wordsInUse.get()) {
            this.ensureCapacity(set.wordsInUse.get());
            this.wordsInUse.set(set.wordsInUse.get());
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            this.words[i].set(this.words[i].get() ^ set.words[i].get());
        }
        if (wordsInCommon < set.wordsInUse.get()) {
            System.arraycopy(set.words, wordsInCommon, this.words, wordsInCommon, set.wordsInUse.get() - wordsInCommon);
        }
        this.recalculateWordsInUse();
    }

    @Override
    public void andNot(IStateBitSet setI) {
        S64BitSet set = (S64BitSet)setI;
        for (int i = Math.min(this.wordsInUse.get(), set.wordsInUse.get()) - 1; i >= 0; --i) {
            this.words[i].set(this.words[i].get() & (set.words[i].get() ^ 0xFFFFFFFFFFFFFFFFL));
        }
        this.recalculateWordsInUse();
    }

    @Override
    public boolean intersects(IStateBitSet setI) {
        S64BitSet set = (S64BitSet)setI;
        for (int i = Math.min(this.wordsInUse.get(), set.wordsInUse.get()) - 1; i >= 0; --i) {
            if ((this.words[i].get() & set.words[i].get()) == 0L) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.wordsInUse.get();
        while (--i >= 0) {
            h ^= this.words[i].get() * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    @Override
    public int size() {
        return this.words.length * 64;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof S64BitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        S64BitSet set = (S64BitSet)obj;
        if (this.wordsInUse != set.wordsInUse) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse.get(); ++i) {
            if (this.words[i] == set.words[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public IStateBitSet copy() {
        S64BitSet result = new S64BitSet(this.environment, this.size());
        result.wordsInUse.set(this.wordsInUse.get());
        for (int i = 0; i < this.wordsInUse.get(); ++i) {
            result.words[i].set(this.words[i].get());
        }
        return result;
    }

    public String toString() {
        int numBits = this.wordsInUse.get() > 128 ? this.cardinality() : this.wordsInUse.get() * 64;
        StringBuilder b = new StringBuilder(6 * numBits + 2);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i < endOfRun);
                i = this.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }
}

