/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing;

import org.chocosolver.memory.AbstractEnvironment;
import org.chocosolver.memory.IStateBool;
import org.chocosolver.memory.IStateDouble;
import org.chocosolver.memory.IStateDoubleVector;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.memory.IStateIntVector;
import org.chocosolver.memory.IStateLong;
import org.chocosolver.memory.structure.Operation;
import org.chocosolver.memory.trailing.StoredBool;
import org.chocosolver.memory.trailing.StoredDouble;
import org.chocosolver.memory.trailing.StoredDoubleVector;
import org.chocosolver.memory.trailing.StoredInt;
import org.chocosolver.memory.trailing.StoredIntVector;
import org.chocosolver.memory.trailing.StoredLong;
import org.chocosolver.memory.trailing.trail.IOperationTrail;
import org.chocosolver.memory.trailing.trail.IStoredBoolTrail;
import org.chocosolver.memory.trailing.trail.IStoredDoubleTrail;
import org.chocosolver.memory.trailing.trail.IStoredIntTrail;
import org.chocosolver.memory.trailing.trail.IStoredLongTrail;
import org.chocosolver.memory.trailing.trail.ITrailStorage;
import org.chocosolver.memory.trailing.trail.StoredDoubleVectorTrail;
import org.chocosolver.memory.trailing.trail.StoredIntVectorTrail;
import org.chocosolver.memory.trailing.trail.chunck.OperationChunckTrail;
import org.chocosolver.memory.trailing.trail.chunck.StoredBoolChunckTrail;
import org.chocosolver.memory.trailing.trail.chunck.StoredDoubleChunckTrail;
import org.chocosolver.memory.trailing.trail.chunck.StoredIntChunckTrail;
import org.chocosolver.memory.trailing.trail.chunck.StoredLongChunckTrail;
import org.chocosolver.memory.trailing.trail.flatten.OperationTrail;
import org.chocosolver.memory.trailing.trail.flatten.StoredBoolTrail;
import org.chocosolver.memory.trailing.trail.flatten.StoredDoubleTrail;
import org.chocosolver.memory.trailing.trail.flatten.StoredIntTrail;
import org.chocosolver.memory.trailing.trail.flatten.StoredLongTrail;
import org.chocosolver.memory.trailing.trail.unsafe.UnsafeBoolTrail;
import org.chocosolver.memory.trailing.trail.unsafe.UnsafeDoubleTrail;
import org.chocosolver.memory.trailing.trail.unsafe.UnsafeIntTrail;
import org.chocosolver.memory.trailing.trail.unsafe.UnsafeLongTrail;

public final class EnvironmentTrailing
extends AbstractEnvironment {
    private int maxWorld = 100;
    private static final int MaxHist = 5000;
    private IStoredIntTrail intTrail;
    private IStoredBoolTrail boolTrail;
    private IStoredLongTrail longTrail;
    private IStoredDoubleTrail doubleTrail;
    private IOperationTrail operationTrail;
    private StoredIntVectorTrail intVectorTrail;
    private StoredDoubleVectorTrail doubleVectorTrail;
    private ITrailStorage[] trails = new ITrailStorage[0];
    private int trailSize = 0;

    public EnvironmentTrailing() {
        super(AbstractEnvironment.Type.FLAT);
    }

    @Override
    public void worldPush() {
        int wi = this.currentWorld + 1;
        for (int i = 0; i < this.trailSize; ++i) {
            this.trails[i].worldPush(wi);
        }
        ++this.currentWorld;
        if (wi == this.maxWorld - 1) {
            this.resizeWorldCapacity(this.maxWorld * 3 / 2);
        }
    }

    @Override
    public void worldPop() {
        int wi = this.currentWorld;
        for (int i = this.trailSize - 1; i >= 0; --i) {
            this.trails[i].worldPop(wi);
        }
        --this.currentWorld;
    }

    @Override
    public void worldCommit() {
        if (this.currentWorld == 0) {
            throw new IllegalStateException("Commit in world 0?");
        }
        int wi = this.currentWorld;
        for (int i = this.trailSize; i >= 0; --i) {
            this.trails[i].worldCommit(wi);
        }
        --this.currentWorld;
    }

    @Override
    public IStateInt makeInt() {
        return this.makeInt(0);
    }

    @Override
    public IStateInt makeInt(int initialValue) {
        return new StoredInt(this, initialValue);
    }

    @Override
    public IStateBool makeBool(boolean initialValue) {
        return new StoredBool(this, initialValue);
    }

    @Override
    public IStateIntVector makeIntVector(int size, int initialValue) {
        return new StoredIntVector(this, size, initialValue);
    }

    @Override
    public IStateDoubleVector makeDoubleVector(int size, double initialValue) {
        return new StoredDoubleVector(this, size, initialValue);
    }

    @Override
    public IStateDouble makeFloat() {
        return this.makeFloat(Double.NaN);
    }

    @Override
    public IStateDouble makeFloat(double initialValue) {
        return new StoredDouble(this, initialValue);
    }

    @Override
    public IStateLong makeLong() {
        return this.makeLong(0L);
    }

    @Override
    public IStateLong makeLong(long init) {
        return new StoredLong(this, init);
    }

    private void increaseTrail() {
        ITrailStorage[] tmp = this.trails;
        this.trails = new ITrailStorage[tmp.length + 1];
        System.arraycopy(tmp, 0, this.trails, 0, tmp.length);
    }

    public IStoredIntTrail getIntTrail() {
        if (this.intTrail == null) {
            switch (this.type) {
                case FLAT: {
                    this.intTrail = new StoredIntTrail(5000, this.maxWorld);
                    break;
                }
                case CHUNK: {
                    this.intTrail = new StoredIntChunckTrail(this.maxWorld);
                    break;
                }
                case UNSAFE: {
                    this.intTrail = new UnsafeIntTrail(this.maxWorld);
                }
            }
            this.increaseTrail();
            this.trails[this.trailSize++] = this.intTrail;
        }
        return this.intTrail;
    }

    public IStoredLongTrail getLongTrail() {
        if (this.longTrail == null) {
            switch (this.type) {
                case FLAT: {
                    this.longTrail = new StoredLongTrail(5000, this.maxWorld);
                    break;
                }
                case CHUNK: {
                    this.longTrail = new StoredLongChunckTrail(this.maxWorld);
                    break;
                }
                case UNSAFE: {
                    this.longTrail = new UnsafeLongTrail(this.maxWorld);
                }
            }
            this.increaseTrail();
            this.trails[this.trailSize++] = this.longTrail;
        }
        return this.longTrail;
    }

    public IStoredBoolTrail getBoolTrail() {
        if (this.boolTrail == null) {
            switch (this.type) {
                case FLAT: {
                    this.boolTrail = new StoredBoolTrail(5000, this.maxWorld);
                    break;
                }
                case CHUNK: {
                    this.boolTrail = new StoredBoolChunckTrail(this.maxWorld);
                    break;
                }
                case UNSAFE: {
                    this.boolTrail = new UnsafeBoolTrail(this.maxWorld);
                }
            }
            this.increaseTrail();
            this.trails[this.trailSize++] = this.boolTrail;
        }
        return this.boolTrail;
    }

    public IStoredDoubleTrail getDoubleTrail() {
        if (this.doubleTrail == null) {
            switch (this.type) {
                case FLAT: {
                    this.doubleTrail = new StoredDoubleTrail(5000, this.maxWorld);
                    break;
                }
                case CHUNK: {
                    this.doubleTrail = new StoredDoubleChunckTrail(this.maxWorld);
                    break;
                }
                case UNSAFE: {
                    this.doubleTrail = new UnsafeDoubleTrail(this.maxWorld);
                }
            }
            this.increaseTrail();
            this.trails[this.trailSize++] = this.doubleTrail;
        }
        return this.doubleTrail;
    }

    public IOperationTrail getOperationTrail() {
        if (this.operationTrail == null) {
            switch (this.type) {
                case FLAT: {
                    this.operationTrail = new OperationTrail(5000, this.maxWorld);
                    break;
                }
                case CHUNK: 
                case UNSAFE: {
                    this.operationTrail = new OperationChunckTrail(this.maxWorld);
                }
            }
            this.increaseTrail();
            this.trails[this.trailSize++] = this.operationTrail;
        }
        return this.operationTrail;
    }

    public StoredIntVectorTrail getIntVectorTrail() {
        if (this.intVectorTrail == null) {
            this.intVectorTrail = new StoredIntVectorTrail(this, 5000, this.maxWorld);
            this.increaseTrail();
            this.trails[this.trailSize++] = this.intVectorTrail;
        }
        return this.intVectorTrail;
    }

    public StoredDoubleVectorTrail getDoubleVectorTrail() {
        if (this.doubleVectorTrail == null) {
            this.doubleVectorTrail = new StoredDoubleVectorTrail(this, 5000, this.maxWorld);
            this.increaseTrail();
            this.trails[this.trailSize++] = this.doubleVectorTrail;
        }
        return this.doubleVectorTrail;
    }

    private void resizeWorldCapacity(int newWorldCapacity) {
        for (ITrailStorage trail : this.trails) {
            trail.resizeWorldCapacity(newWorldCapacity);
        }
        this.maxWorld = newWorldCapacity;
    }

    @Override
    public void save(Operation oldValue) {
        this.getOperationTrail().savePreviousState(oldValue);
    }
}

