/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail;

import org.chocosolver.memory.trailing.EnvironmentTrailing;
import org.chocosolver.memory.trailing.StoredIntVector;
import org.chocosolver.memory.trailing.trail.ITrailStorage;

public class StoredIntVectorTrail
implements ITrailStorage {
    private final EnvironmentTrailing environment;
    private StoredIntVector[] vectorStack;
    private int[] indexStack;
    private int[] valueStack;
    private int[] stampStack;
    private int currentLevel;
    private int[] worldStartLevels;
    private int maxUpdates = 0;

    public StoredIntVectorTrail(EnvironmentTrailing env, int nUpdates, int nWorlds) {
        this.environment = env;
        this.currentLevel = 0;
        this.maxUpdates = nUpdates;
        this.vectorStack = new StoredIntVector[nUpdates];
        this.indexStack = new int[nUpdates];
        this.valueStack = new int[nUpdates];
        this.stampStack = new int[nUpdates];
        this.worldStartLevels = new int[nWorlds];
    }

    public void savePreviousState(StoredIntVector vect, int index, int oldValue, int oldStamp) {
        this.vectorStack[this.currentLevel] = vect;
        this.indexStack[this.currentLevel] = index;
        this.stampStack[this.currentLevel] = oldStamp;
        this.valueStack[this.currentLevel] = oldValue;
        ++this.currentLevel;
        if (this.currentLevel == this.maxUpdates) {
            this.resizeUpdateCapacity();
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = this.maxUpdates * 3 / 2;
        StoredIntVector[] tmp1 = new StoredIntVector[newCapacity];
        System.arraycopy(this.vectorStack, 0, tmp1, 0, this.vectorStack.length);
        this.vectorStack = tmp1;
        int[] tmp2 = new int[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
        int[] tmp3 = new int[newCapacity];
        System.arraycopy(this.stampStack, 0, tmp3, 0, this.stampStack.length);
        this.stampStack = tmp3;
        int[] tmp4 = new int[newCapacity];
        System.arraycopy(this.indexStack, 0, tmp4, 0, this.indexStack.length);
        this.indexStack = tmp4;
        this.maxUpdates = newCapacity;
    }

    @Override
    public void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.worldStartLevels, 0, tmp, 0, this.worldStartLevels.length);
        this.worldStartLevels = tmp;
    }

    @Override
    public void worldPush(int worldIndex) {
        this.worldStartLevels[worldIndex] = this.currentLevel;
    }

    @Override
    public void worldPop(int worldIndex) {
        int wsl = this.worldStartLevels[worldIndex];
        while (this.currentLevel > wsl) {
            --this.currentLevel;
            StoredIntVector v = this.vectorStack[this.currentLevel];
            v._set(this.indexStack[this.currentLevel], this.valueStack[this.currentLevel], this.stampStack[this.currentLevel]);
        }
    }

    @Override
    public void worldCommit(int worldIndex) {
        int startLevel = this.worldStartLevels[this.environment.getWorldIndex()];
        int prevWorld = this.environment.getWorldIndex() - 1;
        int writeIdx = startLevel;
        for (int level = startLevel; level < this.currentLevel; ++level) {
            StoredIntVector var = this.vectorStack[level];
            int idx = this.indexStack[level];
            int val = this.valueStack[level];
            int stamp = this.stampStack[level];
            var.worldStamps[idx] = prevWorld;
            if (stamp == prevWorld) continue;
            if (writeIdx != level) {
                this.valueStack[writeIdx] = val;
                this.indexStack[writeIdx] = idx;
                this.vectorStack[writeIdx] = var;
                this.stampStack[writeIdx] = stamp;
            }
            ++writeIdx;
        }
        this.currentLevel = writeIdx;
    }

    public int getSize() {
        return this.currentLevel;
    }
}

