/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.chunck;

import org.chocosolver.memory.structure.Operation;
import org.chocosolver.memory.trailing.trail.IOperationTrail;

public final class OperationChunckTrail
implements IOperationTrail {
    private static final int CHUNK_SIZE = 10000;
    private Operation[][] operationStack = new Operation[1][];
    private int curChunk = 0;
    private int nextTop = 0;
    private int[] chunks;
    private int[] tops;

    public OperationChunckTrail(int nWorlds) {
        this.operationStack[0] = new Operation[10000];
        this.chunks = new int[nWorlds];
        this.tops = new int[nWorlds];
    }

    @Override
    public void worldPush(int worldIndex) {
        this.chunks[worldIndex] = this.curChunk;
        this.tops[worldIndex] = this.nextTop;
    }

    @Override
    public void worldPop(int worldIndex) {
        int c = this.chunks[worldIndex];
        int t = this.tops[worldIndex];
        for (int cc = this.curChunk; cc >= c; --cc) {
            int to;
            Operation[] cvar = this.operationStack[cc];
            int n = to = cc == c ? t : 0;
            for (int tt = (cc == this.curChunk ? this.nextTop : 10000) - 1; tt >= to; --tt) {
                cvar[tt].undo();
            }
        }
        this.curChunk = c;
        this.nextTop = t;
    }

    public int getSize() {
        return this.curChunk * 10000 + this.nextTop;
    }

    @Override
    public void worldCommit(int worldIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void savePreviousState(Operation operation) {
        this.operationStack[this.curChunk][this.nextTop] = operation;
        ++this.nextTop;
        if (this.nextTop == 10000) {
            ++this.curChunk;
            int l = this.operationStack.length;
            if (this.curChunk == l) {
                this.increase(l);
            }
            this.nextTop = 0;
        }
    }

    private void increase(int l) {
        Operation[][] varBigger = new Operation[l + 1][];
        System.arraycopy(this.operationStack, 0, varBigger, 0, l);
        varBigger[l] = new Operation[10000];
        this.operationStack = varBigger;
    }

    @Override
    public void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.chunks, 0, tmp, 0, this.chunks.length);
        this.chunks = tmp;
        tmp = new int[newWorldCapacity];
        System.arraycopy(this.tops, 0, tmp, 0, this.tops.length);
        this.tops = tmp;
    }
}

