/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.chunck;

import org.chocosolver.memory.trailing.StoredInt;
import org.chocosolver.memory.trailing.trail.IStoredIntTrail;

public class StoredIntChunckTrail
implements IStoredIntTrail {
    private static final int CHUNK_SIZE = 0x100000;
    private StoredInt[][] variableStack = new StoredInt[1][];
    private int[][] valueStack;
    private int[][] stampStack;
    private int curChunk = 0;
    private int nextTop = 0;
    private int[] chunks;
    private int[] tops;

    public StoredIntChunckTrail(int nWorlds) {
        this.variableStack[0] = new StoredInt[0x100000];
        this.valueStack = new int[1][];
        this.valueStack[0] = new int[0x100000];
        this.stampStack = new int[1][];
        this.stampStack[0] = new int[0x100000];
        this.chunks = new int[nWorlds];
        this.tops = new int[nWorlds];
    }

    @Override
    public void worldPush(int worldIndex) {
        this.chunks[worldIndex] = this.curChunk;
        this.tops[worldIndex] = this.nextTop;
    }

    @Override
    public void worldPop(int worldIndex) {
        int c = this.chunks[worldIndex];
        int t = this.tops[worldIndex];
        for (int cc = this.curChunk; cc >= c; --cc) {
            int to;
            StoredInt[] cvar = this.variableStack[cc];
            int[] cval = this.valueStack[cc];
            int[] cstmp = this.stampStack[cc];
            int n = to = cc == c ? t : 0;
            for (int tt = (cc == this.curChunk ? this.nextTop : 0x100000) - 1; tt >= to; --tt) {
                cvar[tt]._set(cval[tt], cstmp[tt]);
            }
        }
        this.curChunk = c;
        this.nextTop = t;
    }

    public int getSize() {
        return this.curChunk * 0x100000 + this.nextTop;
    }

    @Override
    public void worldCommit(int worldIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void savePreviousState(StoredInt v, int oldValue, int oldStamp) {
        this.valueStack[this.curChunk][this.nextTop] = oldValue;
        this.variableStack[this.curChunk][this.nextTop] = v;
        this.stampStack[this.curChunk][this.nextTop] = oldStamp;
        ++this.nextTop;
        if (this.nextTop == 0x100000) {
            ++this.curChunk;
            int l = this.variableStack.length;
            if (this.curChunk == l) {
                this.increase(l);
            }
            this.nextTop = 0;
        }
    }

    @Override
    public void buildFakeHistory(StoredInt v, int initValue, int olderStamp) {
        StoredInt[][] _variableStack = this.variableStack;
        int[][] _valueStack = this.valueStack;
        int[][] _stampStack = this.stampStack;
        int[] _chunks = this.chunks;
        int[] _tops = this.tops;
        int _curChunk = this.curChunk;
        int _nextTop = this.nextTop;
        this.variableStack = new StoredInt[1][];
        this.variableStack[0] = new StoredInt[0x100000];
        this.valueStack = new int[1][];
        this.valueStack[0] = new int[0x100000];
        this.stampStack = new int[1][];
        this.stampStack[0] = new int[0x100000];
        this.chunks = new int[_chunks.length + 1];
        this.tops = new int[_tops.length + 1];
        this.nextTop = 0;
        this.curChunk = 0;
        for (int w = 1; w < olderStamp; ++w) {
            this.rebuild(_chunks[w], _chunks[w + 1], _tops[w], _tops[w + 1], _variableStack, _valueStack, _stampStack);
            this.savePreviousState(v, initValue, w - 1);
            this.worldPush(w + 1);
        }
        this.rebuild(_chunks[olderStamp], _curChunk, _tops[olderStamp], _nextTop, _variableStack, _valueStack, _stampStack);
        this.savePreviousState(v, initValue, olderStamp - 1);
    }

    private void rebuild(int fc, int tc, int ft, int tt, StoredInt[][] _variableStack, int[][] _valueStack, int[][] _stampStack) {
        for (int cc = fc; cc <= tc; ++cc) {
            int to;
            StoredInt[] cvar = _variableStack[cc];
            int[] cval = _valueStack[cc];
            int[] cstmp = _stampStack[cc];
            int n = to = cc == tc ? tt : 0x100000;
            for (int from = cc == fc ? ft : 0; from < to; ++from) {
                this.savePreviousState(cvar[from], cval[from], cstmp[from]);
            }
        }
    }

    private void increase(int l) {
        StoredInt[][] varBigger = new StoredInt[l + 1][];
        System.arraycopy(this.variableStack, 0, varBigger, 0, l);
        varBigger[l] = new StoredInt[0x100000];
        this.variableStack = varBigger;
        int[][] valBigger = new int[l + 1][];
        System.arraycopy(this.valueStack, 0, valBigger, 0, l);
        valBigger[l] = new int[0x100000];
        this.valueStack = valBigger;
        int[][] staBigger = new int[l + 1][];
        System.arraycopy(this.stampStack, 0, staBigger, 0, l);
        staBigger[l] = new int[0x100000];
        this.stampStack = staBigger;
    }

    @Override
    public void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.chunks, 0, tmp, 0, this.chunks.length);
        this.chunks = tmp;
        tmp = new int[newWorldCapacity];
        System.arraycopy(this.tops, 0, tmp, 0, this.tops.length);
        this.tops = tmp;
    }
}

