/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.flatten;

import org.chocosolver.memory.structure.Operation;
import org.chocosolver.memory.trailing.trail.IOperationTrail;

public class OperationTrail
implements IOperationTrail {
    private Operation[] valueStack;
    private int currentLevel = 0;
    private int[] worldStartLevels;

    public OperationTrail(int nUpdates, int nWorlds) {
        this.valueStack = new Operation[nUpdates];
        this.worldStartLevels = new int[nWorlds];
    }

    @Override
    public void worldPush(int worldIndex) {
        this.worldStartLevels[worldIndex] = this.currentLevel;
    }

    @Override
    public void worldPop(int worldIndex) {
        int wsl = this.worldStartLevels[worldIndex];
        while (this.currentLevel > wsl) {
            --this.currentLevel;
            this.valueStack[this.currentLevel].undo();
        }
    }

    public int getSize() {
        return this.currentLevel;
    }

    @Override
    public void worldCommit(int worldIndex) {
    }

    @Override
    public void savePreviousState(Operation oldValue) {
        this.valueStack[this.currentLevel] = oldValue;
        ++this.currentLevel;
        if (this.currentLevel == this.valueStack.length) {
            this.resizeUpdateCapacity();
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = this.valueStack.length * 3 / 2;
        Operation[] tmp2 = new Operation[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
    }

    @Override
    public void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.worldStartLevels, 0, tmp, 0, this.worldStartLevels.length);
        this.worldStartLevels = tmp;
    }
}

