/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.flatten;

import org.chocosolver.memory.trailing.StoredDouble;
import org.chocosolver.memory.trailing.trail.IStoredDoubleTrail;

public class StoredDoubleTrail
implements IStoredDoubleTrail {
    private StoredDouble[] variableStack;
    private double[] valueStack;
    private int[] stampStack;
    private int currentLevel = 0;
    private int[] worldStartLevels;

    public StoredDoubleTrail(int nUpdates, int nWorlds) {
        this.variableStack = new StoredDouble[nUpdates];
        this.valueStack = new double[nUpdates];
        this.stampStack = new int[nUpdates];
        this.worldStartLevels = new int[nWorlds];
    }

    @Override
    public void worldPush(int worldIndex) {
        this.worldStartLevels[worldIndex] = this.currentLevel;
    }

    @Override
    public void worldPop(int worldIndex) {
        int wsl = this.worldStartLevels[worldIndex];
        while (this.currentLevel > wsl) {
            --this.currentLevel;
            StoredDouble v = this.variableStack[this.currentLevel];
            v._set(this.valueStack[this.currentLevel], this.stampStack[this.currentLevel]);
        }
    }

    public int getSize() {
        return this.currentLevel;
    }

    @Override
    public void worldCommit(int worldIndex) {
        int startLevel = this.worldStartLevels[worldIndex];
        int prevWorld = worldIndex - 1;
        int writeIdx = startLevel;
        for (int level = startLevel; level < this.currentLevel; ++level) {
            StoredDouble var = this.variableStack[level];
            double val = this.valueStack[level];
            int stamp = this.stampStack[level];
            var.overrideTimeStamp(prevWorld);
            if (stamp == prevWorld) continue;
            if (writeIdx != level) {
                this.valueStack[writeIdx] = val;
                this.variableStack[writeIdx] = var;
                this.stampStack[writeIdx] = stamp;
            }
            ++writeIdx;
        }
        this.currentLevel = writeIdx;
    }

    @Override
    public void savePreviousState(StoredDouble v, double oldValue, int oldStamp) {
        this.valueStack[this.currentLevel] = oldValue;
        this.variableStack[this.currentLevel] = v;
        this.stampStack[this.currentLevel] = oldStamp;
        ++this.currentLevel;
        if (this.currentLevel == this.valueStack.length) {
            this.resizeUpdateCapacity();
        }
    }

    @Override
    public void buildFakeHistory(StoredDouble v, double initValue, int olderStamp) {
        StoredDouble[] _variableStack = this.variableStack;
        double[] _valueStack = this.valueStack;
        int[] _stampStack = this.stampStack;
        int[] _worldStartLevels = this.worldStartLevels;
        int _maxUpdates = this.variableStack.length + olderStamp;
        int _currentLevel = this.currentLevel;
        this.variableStack = new StoredDouble[_maxUpdates];
        this.valueStack = new double[_maxUpdates];
        this.stampStack = new int[_maxUpdates];
        this.worldStartLevels = new int[this.worldStartLevels.length];
        this.currentLevel = 0;
        for (int w = 1; w < olderStamp; ++w) {
            this.rebuild(_worldStartLevels[w], _worldStartLevels[w + 1], _variableStack, _valueStack, _stampStack);
            this.savePreviousState(v, initValue, w - 1);
            this.worldPush(w + 1);
        }
        this.rebuild(_worldStartLevels[olderStamp], _currentLevel, _variableStack, _valueStack, _stampStack);
        this.savePreviousState(v, initValue, olderStamp - 1);
    }

    private void rebuild(int f, int t, StoredDouble[] _variableStack, double[] _valueStack, int[] _stampStack) {
        System.arraycopy(_variableStack, f, this.variableStack, this.currentLevel, t - f);
        System.arraycopy(_valueStack, f, this.valueStack, this.currentLevel, t - f);
        System.arraycopy(_stampStack, f, this.stampStack, this.currentLevel, t - f);
        this.currentLevel += t - f;
    }

    private void resizeUpdateCapacity() {
        int newCapacity = this.valueStack.length * 3 / 2;
        StoredDouble[] tmp1 = new StoredDouble[newCapacity];
        System.arraycopy(this.variableStack, 0, tmp1, 0, this.variableStack.length);
        this.variableStack = tmp1;
        double[] tmp2 = new double[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
        int[] tmp3 = new int[newCapacity];
        System.arraycopy(this.stampStack, 0, tmp3, 0, this.stampStack.length);
        this.stampStack = tmp3;
    }

    @Override
    public void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.worldStartLevels, 0, tmp, 0, this.worldStartLevels.length);
        this.worldStartLevels = tmp;
    }
}

