/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.flatten;

import org.chocosolver.memory.trailing.StoredLong;
import org.chocosolver.memory.trailing.trail.IStoredLongTrail;

public class StoredLongTrail
implements IStoredLongTrail {
    private StoredLong[] variableStack;
    private long[] valueStack;
    private int[] stampStack;
    private int currentLevel = 0;
    private int[] worldStartLevels;

    public StoredLongTrail(int nUpdates, int nWorlds) {
        this.variableStack = new StoredLong[nUpdates];
        this.valueStack = new long[nUpdates];
        this.stampStack = new int[nUpdates];
        this.worldStartLevels = new int[nWorlds];
    }

    @Override
    public void worldPush(int worldIndex) {
        this.worldStartLevels[worldIndex] = this.currentLevel;
    }

    @Override
    public void worldPop(int worldIndex) {
        int wsl = this.worldStartLevels[worldIndex];
        while (this.currentLevel > wsl) {
            --this.currentLevel;
            StoredLong v = this.variableStack[this.currentLevel];
            v._set(this.valueStack[this.currentLevel], this.stampStack[this.currentLevel]);
        }
    }

    public int getSize() {
        return this.currentLevel;
    }

    @Override
    public void worldCommit(int worldIndex) {
        int startLevel = this.worldStartLevels[worldIndex];
        int prevWorld = worldIndex - 1;
        int writeIdx = startLevel;
        for (int level = startLevel; level < this.currentLevel; ++level) {
            StoredLong var = this.variableStack[level];
            long val = this.valueStack[level];
            int stamp = this.stampStack[level];
            var.overrideTimeStamp(prevWorld);
            if (stamp == prevWorld) continue;
            if (writeIdx != level) {
                this.valueStack[writeIdx] = val;
                this.variableStack[writeIdx] = var;
                this.stampStack[writeIdx] = stamp;
            }
            ++writeIdx;
        }
        this.currentLevel = writeIdx;
    }

    @Override
    public void savePreviousState(StoredLong v, long oldValue, int oldStamp) {
        this.valueStack[this.currentLevel] = oldValue;
        this.variableStack[this.currentLevel] = v;
        this.stampStack[this.currentLevel] = oldStamp;
        ++this.currentLevel;
        if (this.currentLevel == this.valueStack.length) {
            this.resizeUpdateCapacity();
        }
    }

    @Override
    public void buildFakeHistory(StoredLong v, long initValue, int olderStamp) {
        StoredLong[] _variableStack = this.variableStack;
        long[] _valueStack = this.valueStack;
        int[] _stampStack = this.stampStack;
        int[] _worldStartLevels = this.worldStartLevels;
        int _maxUpdates = this.variableStack.length + olderStamp;
        int _currentLevel = this.currentLevel;
        this.variableStack = new StoredLong[_maxUpdates];
        this.valueStack = new long[_maxUpdates];
        this.stampStack = new int[_maxUpdates];
        this.worldStartLevels = new int[this.worldStartLevels.length];
        this.currentLevel = 0;
        for (int w = 1; w < olderStamp; ++w) {
            this.rebuild(_worldStartLevels[w], _worldStartLevels[w + 1], _variableStack, _valueStack, _stampStack);
            this.savePreviousState(v, initValue, w - 1);
            this.worldPush(w + 1);
        }
        this.rebuild(_worldStartLevels[olderStamp], _currentLevel, _variableStack, _valueStack, _stampStack);
        this.savePreviousState(v, initValue, olderStamp - 1);
    }

    private void rebuild(int f, int t, StoredLong[] _variableStack, long[] _valueStack, int[] _stampStack) {
        System.arraycopy(_variableStack, f, this.variableStack, this.currentLevel, t - f);
        System.arraycopy(_valueStack, f, this.valueStack, this.currentLevel, t - f);
        System.arraycopy(_stampStack, f, this.stampStack, this.currentLevel, t - f);
        this.currentLevel += t - f;
    }

    private void resizeUpdateCapacity() {
        int newCapacity = this.variableStack.length * 3 / 2;
        assert (newCapacity >= this.variableStack.length);
        StoredLong[] tmp1 = new StoredLong[newCapacity];
        System.arraycopy(this.variableStack, 0, tmp1, 0, this.variableStack.length);
        this.variableStack = tmp1;
        long[] tmp2 = new long[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
        int[] tmp3 = new int[newCapacity];
        System.arraycopy(this.stampStack, 0, tmp3, 0, this.stampStack.length);
        this.stampStack = tmp3;
    }

    @Override
    public void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.worldStartLevels, 0, tmp, 0, this.worldStartLevels.length);
        this.worldStartLevels = tmp;
    }
}

