/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.unsafe;

import java.lang.reflect.Field;
import org.chocosolver.memory.trailing.StoredDouble;
import org.chocosolver.memory.trailing.trail.IStoredDoubleTrail;
import sun.misc.Unsafe;

public class UnsafeDoubleTrail
implements IStoredDoubleTrail {
    private final Unsafe unsafe = UnsafeDoubleTrail.getTheUnsafe();
    public static final int SIZEOF_DATA = 8;
    public static final int SIZEOF_INT = 4;
    private static final int DEFAULT_CHUNK_SIZE = 20000;
    private StoredDouble[][] variableStack = new StoredDouble[1][];
    private long[] valueStack;
    private long[] stampStack;
    private int curChunk = 0;
    private int nextTop = 0;
    private int[] chunks;
    private int[] tops;

    public UnsafeDoubleTrail(int nWorlds) {
        this.variableStack[0] = new StoredDouble[20000];
        this.valueStack = new long[1];
        assert (this.unsafe != null);
        this.valueStack[0] = this.unsafe.allocateMemory(160000L);
        this.stampStack = new long[1];
        this.stampStack[0] = this.unsafe.allocateMemory(80000L);
        this.chunks = new int[nWorlds];
        this.tops = new int[nWorlds];
    }

    public static Unsafe getTheUnsafe() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void worldPush(int worldIndex) {
        this.chunks[worldIndex] = this.curChunk;
        this.tops[worldIndex] = this.nextTop;
    }

    @Override
    public void worldPop(int worldIndex) {
        int c = this.chunks[worldIndex];
        int t = this.tops[worldIndex];
        for (int cc = this.curChunk; cc >= c; --cc) {
            int to;
            StoredDouble[] cvar = this.variableStack[cc];
            int n = to = cc == c ? t : 0;
            for (int tt = (cc == this.curChunk ? this.nextTop : 20000) - 1; tt >= to; --tt) {
                double cval = this.unsafe.getDouble(this.valueStack[cc] + (long)(tt * 8));
                int cstmp = this.unsafe.getInt(this.stampStack[cc] + (long)(tt * 4));
                cvar[tt]._set(cval, cstmp);
            }
        }
        this.curChunk = c;
        this.nextTop = t;
    }

    public int getSize() {
        return this.curChunk * 20000 + this.nextTop;
    }

    @Override
    public void worldCommit(int worldIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void savePreviousState(StoredDouble v, double oldValue, int oldStamp) {
        this.unsafe.putDouble(this.valueStack[this.curChunk] + (long)(this.nextTop * 8), oldValue);
        this.variableStack[this.curChunk][this.nextTop] = v;
        this.unsafe.putInt(this.stampStack[this.curChunk] + (long)(this.nextTop * 4), oldStamp);
        ++this.nextTop;
        if (this.nextTop == 20000) {
            ++this.curChunk;
            int l = this.variableStack.length;
            if (this.curChunk == l) {
                this.increase(l);
            }
            this.nextTop = 0;
        }
    }

    @Override
    public void buildFakeHistory(StoredDouble v, double initValue, int olderStamp) {
        StoredDouble[][] _variableStack = this.variableStack;
        long[] _valueStack = this.valueStack;
        long[] _stampStack = this.stampStack;
        int[] _chunks = this.chunks;
        int[] _tops = this.tops;
        int _curChunk = this.curChunk;
        int _nextTop = this.nextTop;
        this.variableStack = new StoredDouble[1][];
        this.variableStack[0] = new StoredDouble[20000];
        this.valueStack = new long[1];
        this.valueStack[0] = this.unsafe.allocateMemory(160000L);
        this.stampStack = new long[1];
        this.stampStack[0] = this.unsafe.allocateMemory(80000L);
        this.chunks = new int[_chunks.length + 1];
        this.tops = new int[_tops.length + 1];
        this.nextTop = 0;
        this.curChunk = 0;
        for (int w = 1; w < olderStamp; ++w) {
            this.rebuild(_chunks[w], _chunks[w + 1], _tops[w], _tops[w + 1], _variableStack, _valueStack, _stampStack);
            this.savePreviousState(v, initValue, w - 1);
            this.worldPush(w + 1);
        }
        this.rebuild(_chunks[olderStamp], _curChunk, _tops[olderStamp], _nextTop, _variableStack, _valueStack, _stampStack);
        this.savePreviousState(v, initValue, olderStamp - 1);
        int c = _chunks[0];
        for (int cc = _valueStack.length - 1; cc >= c; --cc) {
            this.unsafe.freeMemory(_valueStack[cc]);
            this.unsafe.freeMemory(_stampStack[cc]);
        }
    }

    private void rebuild(int fc, int tc, int ft, int tt, StoredDouble[][] _variableStack, long[] _valueStack, long[] _stampStack) {
        for (int cc = fc; cc <= tc; ++cc) {
            int to;
            StoredDouble[] cvar = _variableStack[cc];
            int n = to = cc == tc ? tt : 20000;
            for (int from = cc == fc ? ft : 0; from < to; ++from) {
                int cval = this.unsafe.getInt(_valueStack[cc] + (long)(from * 8));
                int cstmp = this.unsafe.getInt(_stampStack[cc] + (long)(from * 4));
                this.savePreviousState(cvar[from], cval, cstmp);
            }
        }
    }

    private void increase(int l) {
        StoredDouble[][] varBigger = new StoredDouble[l + 1][];
        System.arraycopy(this.variableStack, 0, varBigger, 0, l);
        varBigger[l] = new StoredDouble[20000];
        this.variableStack = varBigger;
        long[] valBigger = new long[l + 1];
        System.arraycopy(this.valueStack, 0, valBigger, 0, l);
        valBigger[l] = this.unsafe.allocateMemory(160000L);
        this.valueStack = valBigger;
        long[] staBigger = new long[l + 1];
        System.arraycopy(this.stampStack, 0, staBigger, 0, l);
        staBigger[l] = this.unsafe.allocateMemory(80000L);
        this.stampStack = staBigger;
    }

    @Override
    public void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.chunks, 0, tmp, 0, this.chunks.length);
        this.chunks = tmp;
        tmp = new int[newWorldCapacity];
        System.arraycopy(this.tops, 0, tmp, 0, this.tops.length);
        this.tops = tmp;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        int c = this.chunks[0];
        for (int cc = this.valueStack.length - 1; cc >= c; --cc) {
            this.unsafe.freeMemory(this.valueStack[cc]);
            this.unsafe.freeMemory(this.stampStack[cc]);
        }
    }
}

