/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc;

import java.util.ArrayList;
import org.chocosolver.parser.ParserListener;
import org.chocosolver.parser.flatzinc.Flatzinc;
import org.chocosolver.parser.flatzinc.FznSettings;
import org.chocosolver.parser.flatzinc.layout.FZNLayout;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.trace.Chatterbox;

public class BaseFlatzincListener
implements ParserListener {
    long creationTime;
    final Flatzinc fznparser;

    public BaseFlatzincListener(Flatzinc fznparser) {
        this.fznparser = fznparser;
    }

    @Override
    public void beforeParsingParameters() {
    }

    @Override
    public void afterParsingParameters() {
    }

    @Override
    public void beforeSolverCreation() {
        this.creationTime = -System.nanoTime();
    }

    @Override
    public void afterSolverCreation() {
        this.buildLayout(this.fznparser.instance, this.fznparser.printAllSolutions());
    }

    @Override
    public void beforeParsingFile() {
        System.out.println("% parse instance...");
    }

    @Override
    public void afterParsingFile() {
        if (((FznSettings)this.fznparser.getSolver().getSettings()).printConstraint()) {
            ArrayList<String> l = new ArrayList<String>();
            System.out.println("% INVOLVED CONSTRAINTS (CHOCO) ");
            for (Constraint c : this.fznparser.getSolver().getCstrs()) {
                if (l.contains(c.getName())) continue;
                l.add(c.getName());
                System.out.printf("%% %s", c.getName());
            }
        }
    }

    @Override
    public void beforeConfiguringSearch() {
    }

    @Override
    public void afterConfiguringSearch() {
    }

    @Override
    public void beforeSolving() {
        System.out.println("% solve instance...");
        if (((FznSettings)this.fznparser.getSolver().getSettings()).printSearch()) {
            Chatterbox.showDecisions(this.fznparser.getSolver());
        }
        this.fznparser.getSolver().getMeasures().setReadingTimeCount(this.creationTime + System.nanoTime());
    }

    @Override
    public void afterSolving() {
    }

    public void buildLayout(String instance, boolean printAll) {
        FZNLayout fl = new FZNLayout(instance, printAll);
        this.fznparser.datas.setLayout(fl);
        this.fznparser.getSolver().plugMonitor(fl);
        fl.set(this.fznparser.getSolver());
    }
}

