/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.chocosolver.parser.IParser;
import org.chocosolver.parser.ParserListener;
import org.chocosolver.parser.flatzinc.Flatzinc4Lexer;
import org.chocosolver.parser.flatzinc.Flatzinc4Parser;
import org.chocosolver.parser.flatzinc.FznSettings;
import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.solver.Settings;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.propagation.hardcoded.SevenQueuesPropagatorEngine;
import org.chocosolver.solver.search.loop.monitors.SearchMonitorFactory;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Flatzinc
implements IParser {
    @Argument(required=true, metaVar="VAL", usage="Flatzinc file path.")
    public String instance;
    @Option(name="-a", aliases={"--all"}, usage="Search for all solutions.", required=false)
    protected boolean all = false;
    @Option(name="-f", aliases={"--free-search"}, usage="Ignore search strategy.", required=false)
    protected boolean free = false;
    @Option(name="-p", aliases={"--nb-cores"}, usage="Number of cores available for parallel search", required=false)
    protected int nb_cores = 1;
    @Option(name="-tl", aliases={"--time-limit"}, usage="Time limit.", required=false)
    protected long tl = -1L;
    protected Solver mSolver;
    public Datas datas;
    List<ParserListener> listeners = new LinkedList<ParserListener>();
    protected Settings defaultSettings = new FznSettings();

    public Flatzinc() {
    }

    public Flatzinc(boolean all, boolean free, int nb_cores, long tl) {
        this.all = all;
        this.free = free;
        this.nb_cores = nb_cores;
        this.tl = tl;
    }

    @Override
    public void addListener(ParserListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ParserListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void parseParameters(String[] args) {
        this.listeners.forEach(ParserListener::beforeParsingParameters);
        CmdLineParser cmdparser = new CmdLineParser(this);
        cmdparser.setUsageWidth(160);
        try {
            cmdparser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("ParseAndSolve [options...] VAL");
            cmdparser.printUsage(System.err);
            System.err.println();
            return;
        }
        cmdparser.getArguments();
        this.listeners.forEach(ParserListener::afterParsingParameters);
    }

    @Override
    public void defineSettings(Settings defaultSettings) {
        this.defaultSettings = defaultSettings;
    }

    @Override
    public void createSolver() {
        this.listeners.forEach(ParserListener::beforeSolverCreation);
        this.mSolver = new Solver();
        this.mSolver.set(this.defaultSettings);
        this.datas = new Datas();
        this.listeners.forEach(ParserListener::afterSolverCreation);
    }

    @Override
    public void parseInputFile() throws FileNotFoundException {
        this.listeners.forEach(ParserListener::beforeParsingFile);
        this.parse(new FileInputStream(new File(this.instance)));
        this.listeners.forEach(ParserListener::afterParsingFile);
    }

    public void parse(InputStream is) {
        UnbufferedCharStream input = new UnbufferedCharStream(is);
        Flatzinc4Lexer lexer = new Flatzinc4Lexer(input);
        lexer.setTokenFactory(new CommonTokenFactory(true));
        UnbufferedTokenStream tokens = new UnbufferedTokenStream(lexer);
        Flatzinc4Parser parser = new Flatzinc4Parser(tokens);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.setBuildParseTree(false);
        parser.setTrimParseTree(false);
        parser.flatzinc_model(this.mSolver, this.datas, this.all, this.free);
    }

    @Override
    public void configureSearch() {
        this.listeners.forEach(ParserListener::beforeConfiguringSearch);
        this.mSolver.set(new SevenQueuesPropagatorEngine(this.mSolver));
        if (this.tl > -1L) {
            SearchMonitorFactory.limitTime(this.mSolver, this.tl);
        }
        this.listeners.forEach(ParserListener::afterConfiguringSearch);
    }

    @Override
    public void solve() {
        this.listeners.forEach(ParserListener::beforeSolving);
        this.mSolver.getSearchLoop().launch(!this.mSolver.getObjectiveManager().isOptimization() && !this.all);
        this.listeners.forEach(ParserListener::afterSolving);
    }

    @Override
    public Solver getSolver() {
        return this.mSolver;
    }

    public boolean printAllSolutions() {
        return this.all;
    }
}

