/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.bind.DefaultSearchBinder;
import org.chocosolver.solver.search.strategy.ISF;
import org.chocosolver.solver.search.strategy.SSF;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.slf4j.LoggerFactory;

public class FznSearchBinder
extends DefaultSearchBinder {
    @Override
    public void configureSearch(Solver solver) {
        AbstractStrategy current = solver.getStrategy();
        if (current == null) {
            super.configureSearch(solver);
        } else {
            Variable[] allVars = current.getVariables();
            HashSet<Variable> declaredVariables = new HashSet<Variable>(Arrays.asList(allVars));
            ArrayList<IntVar> decintvars = new ArrayList<IntVar>();
            ArrayList<IntVar> intvars = new ArrayList<IntVar>();
            ArrayList<BoolVar> decboolvars = new ArrayList<BoolVar>();
            ArrayList<BoolVar> boolvars = new ArrayList<BoolVar>();
            ArrayList<SetVar> decsetvars = new ArrayList<SetVar>();
            ArrayList<SetVar> setvars = new ArrayList<SetVar>();
            block5: for (Variable v : allVars) {
                switch (v.getTypeAndKind() & 0xF8) {
                    case 24: {
                        if ((v.getTypeAndKind() & 7) != 1) continue block5;
                        if (declaredVariables.contains(v)) {
                            decboolvars.add((BoolVar)v);
                            continue block5;
                        }
                        boolvars.add((BoolVar)v);
                        continue block5;
                    }
                    case 8: {
                        if ((v.getTypeAndKind() & 7) != 1) continue block5;
                        if (declaredVariables.contains(v)) {
                            decintvars.add((IntVar)v);
                            continue block5;
                        }
                        intvars.add((IntVar)v);
                        continue block5;
                    }
                    case 64: {
                        if ((v.getTypeAndKind() & 7) != 1) continue block5;
                        if (declaredVariables.contains(v)) {
                            decsetvars.add((SetVar)v);
                            continue block5;
                        }
                        setvars.add((SetVar)v);
                        continue block5;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown type of variable: " + v);
                    }
                }
            }
            if (decboolvars.size() == 0) {
                decboolvars.addAll(boolvars);
                boolvars.clear();
            }
            if (decintvars.size() == 0) {
                decintvars.addAll(intvars);
                intvars.clear();
            }
            if (decsetvars.size() == 0) {
                decsetvars.addAll(decsetvars);
                decsetvars.clear();
            }
            ArrayList<AbstractStrategy> strats = new ArrayList<AbstractStrategy>();
            if (decintvars.size() > 0) {
                strats.add(ISF.domOverWDeg(decintvars.toArray(new IntVar[decintvars.size()]), 29091981L));
            }
            if (decboolvars.size() > 0) {
                strats.add(ISF.lexico_UB(decboolvars.toArray(new BoolVar[decboolvars.size()])));
            }
            if (decsetvars.size() > 0) {
                strats.add(SSF.force_first(decsetvars.toArray(new SetVar[decsetvars.size()])));
            }
            intvars.addAll(boolvars);
            if (intvars.size() > 0) {
                strats.add(FznSearchBinder.makeComplementarySearch(intvars.toArray(new IntVar[intvars.size()])));
            }
            if (setvars.size() > 0) {
                LoggerFactory.getLogger(FznSearchBinder.class).warn("% No complementary search for SetVar");
            }
            if (strats.size() == 1) {
                solver.set((AbstractStrategy)strats.get(0));
            } else {
                solver.set(ISF.sequencer(strats.toArray(new AbstractStrategy[strats.size()])));
            }
        }
    }

    private static AbstractStrategy makeComplementarySearch(final IntVar[] ivars) {
        Arrays.sort(ivars, new Comparator<IntVar>(){

            @Override
            public int compare(IntVar o1, IntVar o2) {
                return o1.getDomainSize() - o2.getDomainSize();
            }
        });
        return new AbstractStrategy<IntVar>(ivars){
            boolean created;
            Decision d;
            {
                super((Variable[])x0);
                this.created = false;
                this.d = new Decision<IntVar>(){

                    @Override
                    public void apply() throws ContradictionException {
                        for (int i = 0; i < ivars.length; ++i) {
                            if (ivars[i].isInstantiated()) continue;
                            ivars[i].instantiateTo(ivars[i].getLB(), this);
                            ivars[i].getSolver().propagate();
                        }
                    }

                    @Override
                    public Object getDecisionValue() {
                        return null;
                    }

                    @Override
                    public void free() {
                        created = false;
                    }

                    public String toString() {
                        StringBuilder st = new StringBuilder("(once)");
                        for (int i = 0; i < ivars.length; ++i) {
                            if (ivars[i].isInstantiated()) continue;
                            st.append(ivars[i]).append("=").append(ivars[i].getLB()).append(", ");
                        }
                        return st.toString();
                    }
                };
            }

            @Override
            public void init() throws ContradictionException {
            }

            @Override
            public Decision<IntVar> getDecision() {
                if (!this.created) {
                    this.created = true;
                    this.d.once(true);
                    return this.d;
                }
                return null;
            }
        };
    }
}

