/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.List;
import org.chocosolver.parser.flatzinc.ast.declaration.Declaration;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.parser.flatzinc.layout.FZNLayout;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public class Datas {
    final THashMap<String, Object> map = new THashMap();
    final THashSet<IntVar> intsearchVariables = new THashSet();
    final THashSet<SetVar> setsearchVariables = new THashSet();
    final THashSet<Variable> outputVariables = new THashSet();
    FZNLayout mLayout;

    public void register(String name, Object o) {
        this.map.put(name, o);
    }

    public Object get(String id) {
        return this.map.get(id);
    }

    public void addSearchVars(Variable ... vars) {
        for (int i = 0; i < vars.length; ++i) {
            if ((vars[i].getTypeAndKind() & 8) != 0) {
                this.intsearchVariables.addAll(Arrays.asList((IntVar)vars[i]));
                continue;
            }
            this.setsearchVariables.addAll(Arrays.asList((SetVar)vars[i]));
        }
    }

    public IntVar[] getIntSearchVars() {
        return this.intsearchVariables.toArray(new IntVar[this.intsearchVariables.size()]);
    }

    public SetVar[] getSetSearchVars() {
        return this.setsearchVariables.toArray(new SetVar[this.setsearchVariables.size()]);
    }

    public Variable[] getOutputVars() {
        return this.outputVariables.toArray(new Variable[this.outputVariables.size()]);
    }

    public void declareOutput(String name, Variable variable, Declaration type) {
        this.mLayout.addOutputVar(name, variable, type);
        this.outputVariables.add(variable);
    }

    public void declareOutput(String name, Variable[] variables, List<Expression> indices, Declaration type) {
        this.mLayout.addOutputArrays(name, variables, indices, type);
        this.outputVariables.addAll(Arrays.asList(variables));
    }

    public void setLayout(FZNLayout layout) {
        this.mLayout = layout;
    }

    public void clear() {
        this.map.clear();
        this.intsearchVariables.clear();
        this.setsearchVariables.clear();
    }
}

