/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.chocosolver.parser.flatzinc.FZNException;
import org.chocosolver.parser.flatzinc.FznSettings;
import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.parser.flatzinc.ast.constraints.IBuilder;
import org.chocosolver.parser.flatzinc.ast.expression.EAnnotation;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;

public final class FConstraint {
    private static final String ERROR_MSG = "Cant load manager by reflection: ";
    static Properties properties = new Properties();
    private static THashMap<String, IBuilder> builders = new THashMap();
    private static IBuilder builder;
    private static String last;

    public static void make_constraint(Solver aSolver, Datas datas, String id, List<Expression> exps, List<EAnnotation> annotations) {
        if (!last.equals(id)) {
            if (builders.containsKey(id)) {
                builder = builders.get(id);
            } else {
                String name = properties.getProperty(id);
                if (name == null) {
                    throw new FZNException("Unknown constraint: " + id);
                }
                builder = (IBuilder)FConstraint.loadManager(name);
                if (((FznSettings)aSolver.getSettings()).printConstraint()) {
                    System.out.printf("%% %s", name);
                }
                builders.put(id, builder);
            }
            last = id;
        }
        builder.build(aSolver, id, exps, annotations, datas);
    }

    private static Object loadManager(String name) {
        try {
            return Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new FZNException(ERROR_MSG + name);
        }
    }

    public static void readAnnotations(Datas datas, List<EAnnotation> annotations, Constraint[] cstr) {
        for (int i = 0; i < annotations.size(); ++i) {
            EAnnotation eanno = annotations.get(i);
            try {
                Annotation varanno = Annotation.valueOf(eanno.id.value);
                switch (varanno) {
                    case name: {
                        String name = eanno.exps.get(0).toString();
                        if (name.startsWith("\"") && name.endsWith("\"")) {
                            name = name.substring(1, name.length() - 1);
                        }
                        datas.register(name, cstr);
                        break;
                    }
                }
                continue;
            }
            catch (IllegalArgumentException ignored) {
                // empty catch block
            }
        }
    }

    static {
        last = "";
        InputStream is = FConstraint.class.getResourceAsStream("/fzn_manager.properties");
        try {
            properties.load(is);
        }
        catch (IOException e) {
            throw new FZNException("Could not open fzn_manager.properties");
        }
    }

    private static enum Annotation {
        name;

    }
}

