/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast;

import java.util.List;
import org.chocosolver.parser.flatzinc.FZNException;
import org.chocosolver.parser.flatzinc.ast.expression.EAnnotation;
import org.chocosolver.parser.flatzinc.ast.expression.EArray;
import org.chocosolver.parser.flatzinc.ast.expression.EIdentifier;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.parser.flatzinc.ast.searches.Assignment;
import org.chocosolver.parser.flatzinc.ast.searches.IntSearch;
import org.chocosolver.parser.flatzinc.ast.searches.SetSearch;
import org.chocosolver.parser.flatzinc.ast.searches.VarChoice;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.objective.ObjectiveManager;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.StrategiesSequencer;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public class FGoal {
    public static void define_goal(Solver aSolver, boolean freeSearch, List<EAnnotation> annotations, ResolutionPolicy type, Expression expr) {
        IntVar obj = null;
        if (type != ResolutionPolicy.SATISFACTION) {
            obj = expr.intVarValue(aSolver);
        }
        aSolver.set(new ObjectiveManager(obj, type, true));
        Variable[] vars = aSolver.getVars();
        IntVar[] ivars = new IntVar[vars.length];
        for (int i = 0; i < ivars.length; ++i) {
            ivars[i] = (IntVar)vars[i];
        }
        StringBuilder description = new StringBuilder();
        if (annotations.size() > 0) {
            AbstractStrategy strategy;
            if (annotations.size() > 1) {
                throw new UnsupportedOperationException("SolveGoal:: wrong annotations size");
            }
            EAnnotation annotation = annotations.get(0);
            if (annotation.id.value.equals("seq_search")) {
                EArray earray = (EArray)annotation.exps.get(0);
                AbstractStrategy[] strategies = new AbstractStrategy[earray.what.size()];
                for (int i = 0; i < strategies.length; ++i) {
                    strategies[i] = FGoal.readSearchAnnotation((EAnnotation)earray.getWhat_i(i), aSolver, description);
                }
                strategy = new StrategiesSequencer(aSolver.getEnvironment(), strategies);
            } else {
                strategy = FGoal.readSearchAnnotation(annotation, aSolver, description);
            }
            aSolver.set(strategy);
        }
        if (freeSearch || annotations.size() == 0) {
            aSolver.getSettings().getSearchBinder().configureSearch(aSolver);
        }
    }

    private static AbstractStrategy readSearchAnnotation(EAnnotation e, Solver solver, StringBuilder description) {
        Expression[] exps = new Expression[e.exps.size()];
        e.exps.toArray(exps);
        Search search = Search.valueOf(e.id.value);
        VarChoice vchoice = VarChoice.valueOf(((EIdentifier)exps[1]).value);
        description.append(vchoice.toString()).append(";");
        Assignment assignment = Assignment.valueOf(((EIdentifier)exps[2]).value);
        switch (search) {
            case int_search: 
            case bool_search: {
                IntVar[] scope = exps[0].toIntVarArray(solver);
                return IntSearch.build(scope, vchoice, assignment, solver);
            }
            case set_search: {
                SetVar[] scope = exps[0].toSetVarArray(solver);
                return SetSearch.build(scope, vchoice, assignment);
            }
        }
        System.err.println("Unknown search annotation " + e.toString());
        throw new FZNException();
    }

    private static enum Search {
        int_search,
        bool_search,
        set_search;

    }
}

