/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast;

import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.parser.flatzinc.ast.Exit;
import org.chocosolver.parser.flatzinc.ast.declaration.DArray;
import org.chocosolver.parser.flatzinc.ast.declaration.DInt2;
import org.chocosolver.parser.flatzinc.ast.declaration.Declaration;
import org.chocosolver.parser.flatzinc.ast.expression.EArray;
import org.chocosolver.parser.flatzinc.ast.expression.EBool;
import org.chocosolver.parser.flatzinc.ast.expression.EInt;
import org.chocosolver.parser.flatzinc.ast.expression.ESet;
import org.chocosolver.parser.flatzinc.ast.expression.ESetBounds;
import org.chocosolver.parser.flatzinc.ast.expression.ESetList;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;

public final class FParameter {
    public static void make_parameter(Datas datas, Declaration type, String identifier, Expression expression) {
        switch (type.typeOf) {
            case BOOL: {
                FParameter.buildBool(identifier, (EBool)expression, datas);
                break;
            }
            case INT: 
            case INT2: 
            case INTN: {
                FParameter.buildInt(identifier, (EInt)expression, datas);
                break;
            }
            case SET: 
            case SETOFINT: {
                FParameter.buildSet(identifier, (ESet)expression, datas);
                break;
            }
            case ARRAY: {
                DArray arr = (DArray)type;
                if (arr.getDimension() == 1) {
                    DInt2 index = (DInt2)arr.getIndex(0);
                    FParameter.buildArray(identifier, index, arr.getWhat(), (EArray)expression, datas);
                    break;
                }
                Exit.log("cannot handle more than one dimension!");
            }
        }
    }

    private static boolean buildBool(String name, EBool value, Datas datas) {
        boolean b = value.value;
        datas.register(name, b);
        return b;
    }

    private static int buildInt(String name, EInt value, Datas datas) {
        int i = value.value;
        datas.register(name, i);
        return i;
    }

    private static int[] buildSet(String name, ESet set, Datas datas) {
        int[] s;
        switch (set.getTypeOf()) {
            case SET_B: {
                ESetBounds bset = (ESetBounds)set;
                s = bset.enumVal();
                break;
            }
            case SET_L: {
                ESetList lset = (ESetList)set;
                s = lset.enumVal();
                break;
            }
            default: {
                s = null;
                Exit.log("Unknown expression");
            }
        }
        datas.register(name, s);
        return s;
    }

    private static void buildArray(String name, DInt2 index, Declaration what, EArray value, Datas datas) {
        int size = index.getUpp();
        switch (what.typeOf) {
            case BOOL: {
                boolean[] barr = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    barr[i] = ((EBool)value.getWhat_i((int)i)).value;
                }
                datas.register(name, barr);
                break;
            }
            case INT: 
            case INT2: 
            case INTN: {
                int[] iarr = new int[size];
                for (int i = 0; i < size; ++i) {
                    iarr[i] = ((EInt)value.getWhat_i((int)i)).value;
                }
                datas.register(name, iarr);
                break;
            }
            case SET: {
                int[][] sarr = new int[size][];
                for (int i = 0; i < size; ++i) {
                    sarr[i] = ((ESet)value.getWhat_i(i)).enumVal();
                }
                datas.register(name, sarr);
                break;
            }
            case SETOFINT: {
                int[][] sarr = new int[size][];
                for (int i = 0; i < size; ++i) {
                    sarr[i] = ((ESet)value.getWhat_i(i)).enumVal();
                }
                datas.register(name, sarr);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Parameter#buildArray ARRAY: unexpected type for " + name);
            }
        }
    }
}

