/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast;

import java.util.List;
import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.parser.flatzinc.ast.Exit;
import org.chocosolver.parser.flatzinc.ast.declaration.DArray;
import org.chocosolver.parser.flatzinc.ast.declaration.DInt2;
import org.chocosolver.parser.flatzinc.ast.declaration.DManyInt;
import org.chocosolver.parser.flatzinc.ast.declaration.DSet;
import org.chocosolver.parser.flatzinc.ast.declaration.Declaration;
import org.chocosolver.parser.flatzinc.ast.expression.EAnnotation;
import org.chocosolver.parser.flatzinc.ast.expression.EArray;
import org.chocosolver.parser.flatzinc.ast.expression.EIdArray;
import org.chocosolver.parser.flatzinc.ast.expression.EIdentifier;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.IntConstraintFactory;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.VariableFactory;

public final class FVariable {
    private static final boolean DEBUG = true;
    private static final String NO_NAME = "";
    private static final String output_var = "out";
    private static final String output_array = "out";
    private static final String is_defined_var = "is_";
    private static final String var_is_introduced = "var";

    public static void make_variable(Datas datas, Declaration type, String identifier, List<EAnnotation> annotations, Expression expression, Solver aSolver) {
        switch (type.typeOf) {
            case INT: {
                IntVar iv = FVariable.buildWithInt(identifier, expression, datas, aSolver);
                FVariable.readAnnotations(identifier, iv, type, annotations, datas);
                break;
            }
            case INT2: {
                IntVar iv = FVariable.buildWithInt2(identifier, (DInt2)type, expression, datas, aSolver);
                FVariable.readAnnotations(identifier, iv, type, annotations, datas);
                break;
            }
            case INTN: {
                IntVar iv = FVariable.buildWithManyInt(identifier, (DManyInt)type, expression, datas, aSolver);
                FVariable.readAnnotations(identifier, iv, type, annotations, datas);
                break;
            }
            case BOOL: {
                BoolVar bv = FVariable.buildWithBool(identifier, expression, datas, aSolver);
                FVariable.readAnnotations(identifier, bv, type, annotations, datas);
                break;
            }
            case SET: {
                SetVar sv = FVariable.buildWithSet(identifier, (DSet)type, expression, datas, aSolver);
                FVariable.readAnnotations(identifier, sv, type, annotations, datas);
                break;
            }
            case ARRAY: {
                Variable[] vs = expression == null ? FVariable.buildWithDArray(identifier, (DArray)type, null, datas, aSolver) : FVariable.buildWithDArray(identifier, (DArray)type, expression, datas, aSolver);
                FVariable.readAnnotations(identifier, vs, type, annotations, datas);
            }
        }
    }

    private static void readAnnotations(String name, Variable var, Declaration type, List<EAnnotation> expressions, Datas datas) {
        boolean is_introduced = false;
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expression = expressions.get(i);
            Expression.EType etype = expression.getTypeOf();
            String varanno = NO_NAME;
            switch (etype) {
                case IDE: {
                    EIdentifier identifier = (EIdentifier)expression;
                    varanno = identifier.value;
                    break;
                }
                case ANN: {
                    EAnnotation eanno = (EAnnotation)expression;
                    varanno = eanno.id.value;
                }
            }
            if (varanno.startsWith("out")) {
                datas.declareOutput(name, var, type);
                continue;
            }
            if (!varanno.startsWith(var_is_introduced)) continue;
            is_introduced = true;
        }
        if (!is_introduced) {
            datas.addSearchVars(var);
        }
    }

    private static void readAnnotations(String name, Variable[] vars, Declaration type, List<EAnnotation> expressions, Datas datas) {
        boolean is_introduced = false;
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expression = expressions.get(i);
            Expression.EType etype = expression.getTypeOf();
            String varanno = NO_NAME;
            switch (etype) {
                case IDE: {
                    EIdentifier identifier = (EIdentifier)expression;
                    varanno = identifier.value;
                    break;
                }
                case ANN: {
                    EAnnotation eanno = (EAnnotation)expression;
                    varanno = eanno.id.value;
                }
            }
            if (varanno.startsWith("out")) {
                EAnnotation eanno = (EAnnotation)expression;
                datas.declareOutput(name, vars, eanno.exps, type);
                continue;
            }
            if (!varanno.startsWith(var_is_introduced)) continue;
            is_introduced = true;
        }
        if (!is_introduced) {
            datas.addSearchVars(vars);
        }
    }

    private static BoolVar buildWithBool(String name, Expression expression, Datas datas, Solver solver) {
        BoolVar bi = expression != null ? (BoolVar)FVariable.buildOnExpression(name, expression, datas, solver) : VariableFactory.bool(name, solver);
        datas.register(name, bi);
        return bi;
    }

    private static IntVar buildWithInt(String name, Expression expression, Datas datas, Solver solver) {
        IntVar iv = expression != null ? FVariable.buildOnExpression(name, expression, datas, solver) : VariableFactory.integer(name, -999999, 999999, solver);
        datas.register(name, iv);
        return iv;
    }

    private static IntVar buildWithInt2(String name, DInt2 type, Expression expression, Datas datas, Solver solver) {
        IntVar iv;
        if (expression != null) {
            iv = FVariable.buildOnExpression(name, expression, datas, solver);
            int lb = type.getLow();
            int ub = type.getUpp();
            solver.post(IntConstraintFactory.member(iv, lb, ub));
        } else {
            iv = VariableFactory.integer(name, type.getLow(), type.getUpp(), solver);
        }
        datas.register(name, iv);
        return iv;
    }

    private static IntVar buildWithManyInt(String name, DManyInt type, Expression expression, Datas datas, Solver solver) {
        IntVar iv;
        if (expression != null) {
            iv = FVariable.buildOnExpression(name, expression, datas, solver);
            int[] values = type.getValues();
            solver.post(IntConstraintFactory.member(iv, values));
        } else {
            iv = VariableFactory.enumerated(name, type.getValues(), solver);
        }
        datas.register(name, iv);
        return iv;
    }

    private static IntVar buildOnExpression(String name, Expression expression, Datas datas, Solver solver) {
        IntVar iv;
        switch (expression.getTypeOf()) {
            case BOO: {
                iv = expression.boolVarValue(solver);
                break;
            }
            case INT: {
                iv = VariableFactory.fixed(name, expression.intValue(), solver);
                break;
            }
            case IDE: {
                iv = VariableFactory.eq((IntVar)datas.get(expression.toString()));
                break;
            }
            case IDA: {
                EIdArray eida = (EIdArray)expression;
                iv = ((IntVar[])datas.get(eida.name))[eida.index - 1];
                break;
            }
            default: {
                iv = null;
                Exit.log("Unknown expression");
            }
        }
        return iv;
    }

    private static SetVar buildWithSet(String name, DSet type, Expression expression, Datas datas, Solver solver) {
        SetVar sv;
        Declaration what = type.getWhat();
        switch (what.typeOf) {
            case INT2: {
                if (expression == null) {
                    DInt2 bounds = (DInt2)what;
                    sv = VariableFactory.set(name, bounds.getLow(), bounds.getUpp(), solver);
                    break;
                }
                Exit.log();
                sv = null;
                break;
            }
            case INTN: {
                DManyInt mint = (DManyInt)what;
                if (expression == null) {
                    sv = VariableFactory.set(name, mint.getValues(), solver);
                    break;
                }
                sv = null;
                Exit.log("Unknown expression");
                break;
            }
            default: {
                sv = null;
                Exit.log("Unknown expression");
            }
        }
        datas.register(name, sv);
        return sv;
    }

    private static Variable[] buildWithDArray(String name, DArray type, Expression expression, Datas datas, Solver solver) {
        DInt2 index = (DInt2)type.getIndex(0);
        int size = index.getUpp();
        Declaration what = type.getWhat();
        Variable[] vs = null;
        switch (what.typeOf) {
            case BOOL: {
                BoolVar[] bs = new BoolVar[size];
                if (expression == null) {
                    for (int i = 1; i <= size; ++i) {
                        bs[i - 1] = FVariable.buildWithBool(name + '_' + i, null, datas, solver);
                    }
                } else if (expression.getTypeOf().equals((Object)Expression.EType.ARR)) {
                    EArray array = (EArray)expression;
                    for (int i = 0; i < size; ++i) {
                        bs[i] = array.getWhat_i(i).boolVarValue(solver);
                    }
                }
                datas.register(name, bs);
                vs = bs;
                break;
            }
            case INT: {
                vs = new IntVar[size];
                if (expression == null) {
                    for (int i = 1; i <= size; ++i) {
                        vs[i - 1] = FVariable.buildWithInt(name + '_' + i, null, datas, solver);
                    }
                } else if (expression.getTypeOf().equals((Object)Expression.EType.ARR)) {
                    FVariable.buildFromIntArray(vs, (EArray)expression, size, solver);
                }
                datas.register(name, vs);
                break;
            }
            case INT2: {
                vs = new IntVar[size];
                if (expression == null) {
                    for (int i = 1; i <= size; ++i) {
                        vs[i - 1] = FVariable.buildWithInt2(name + '_' + i, (DInt2)what, null, datas, solver);
                    }
                } else if (expression.getTypeOf().equals((Object)Expression.EType.ARR)) {
                    FVariable.buildFromIntArray(vs, (EArray)expression, size, solver);
                }
                datas.register(name, vs);
                break;
            }
            case INTN: {
                vs = new IntVar[size];
                if (expression == null) {
                    for (int i = 1; i <= size; ++i) {
                        vs[i - 1] = FVariable.buildWithManyInt(name + '_' + i, (DManyInt)what, null, datas, solver);
                    }
                } else if (expression.getTypeOf().equals((Object)Expression.EType.ARR)) {
                    FVariable.buildFromIntArray(vs, (EArray)expression, size, solver);
                }
                datas.register(name, vs);
                break;
            }
            case SET: {
                vs = new SetVar[size];
                for (int i = 1; i <= size; ++i) {
                    vs[i - 1] = FVariable.buildWithSet(name + '_' + i, (DSet)what, expression, datas, solver);
                }
                datas.register(name, vs);
                break;
            }
        }
        return vs;
    }

    private static void buildFromIntArray(Variable[] vs, EArray array, int size, Solver solver) {
        for (int i = 0; i < size; ++i) {
            vs[i] = array.getWhat_i(i).intVarValue(solver);
        }
    }
}

