/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.constraints;

import java.util.List;
import org.chocosolver.parser.flatzinc.FznSettings;
import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.parser.flatzinc.ast.constraints.IBuilder;
import org.chocosolver.parser.flatzinc.ast.expression.EAnnotation;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.SatFactory;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

public class BoolLeReifBuilder
implements IBuilder {
    @Override
    public void build(Solver solver, String name, List<Expression> exps, List<EAnnotation> annotations, Datas datas) {
        BoolVar a = exps.get(0).boolVarValue(solver);
        BoolVar b = exps.get(1).boolVarValue(solver);
        BoolVar r = exps.get(2).boolVarValue(solver);
        if (((FznSettings)solver.getSettings()).enableClause()) {
            SatFactory.addBoolIsLeVar(a, b, r);
        } else if (((FznSettings)solver.getSettings()).adhocReification()) {
            solver.post(new Constraint("reifBool(a<b,r)", new Propagator<BoolVar>(new BoolVar[]{a, b, r}, PropagatorPriority.TERNARY, false){

                @Override
                public void propagate(int evtmask) throws ContradictionException {
                    if (((BoolVar[])this.vars)[0].contains(0) || ((BoolVar[])this.vars)[1].contains(1)) {
                        ((BoolVar[])this.vars)[2].setToTrue(this.aCause);
                    }
                    if (((BoolVar[])this.vars)[2].getUB() == 0) {
                        ((BoolVar[])this.vars)[0].setToTrue(this.aCause);
                        ((BoolVar[])this.vars)[1].setToFalse(this.aCause);
                    }
                }

                @Override
                public ESat isEntailed() {
                    throw new UnsupportedOperationException("isEntailed not implemented ");
                }
            }));
        } else {
            ICF.arithm((IntVar)a, "<=", b).reifyWith(r);
        }
    }
}

