/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.constraints;

import java.util.List;
import org.chocosolver.parser.flatzinc.FznSettings;
import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.parser.flatzinc.ast.constraints.IBuilder;
import org.chocosolver.parser.flatzinc.ast.expression.EAnnotation;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.SatFactory;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

public class IntEqReifBuilder
implements IBuilder {
    @Override
    public void build(Solver solver, String name, List<Expression> exps, List<EAnnotation> annotations, Datas datas) {
        IntVar a = exps.get(0).intVarValue(solver);
        IntVar b = exps.get(1).intVarValue(solver);
        final BoolVar r = exps.get(2).boolVarValue(solver);
        if (((FznSettings)solver.getSettings()).enableClause() && (a.getTypeAndKind() & 0xF8) == 24 && (b.getTypeAndKind() & 0xF8) == 24) {
            SatFactory.addBoolIsEqVar((BoolVar)a, (BoolVar)b, r);
        } else if (((FznSettings)solver.getSettings()).adhocReification()) {
            if (a.isInstantiated() || b.isInstantiated()) {
                int c;
                IntVar x;
                if (a.isInstantiated()) {
                    x = b;
                    c = a.getValue();
                } else {
                    x = a;
                    c = b.getValue();
                }
                final IntVar var = x;
                final int cste = c;
                solver.post(new Constraint("reif(a=cste,r)", new Propagator<IntVar>(new IntVar[]{x, r}, PropagatorPriority.BINARY, false){

                    @Override
                    public void propagate(int evtmask) throws ContradictionException {
                        if (r.getLB() == 1) {
                            var.instantiateTo(cste, this.aCause);
                            this.setPassive();
                        } else if (r.getUB() == 0) {
                            if (var.removeValue(cste, this.aCause) || !var.contains(cste)) {
                                this.setPassive();
                            }
                        } else if (var.isInstantiatedTo(cste)) {
                            r.setToTrue(this.aCause);
                            this.setPassive();
                        } else if (!var.contains(cste)) {
                            r.setToFalse(this.aCause);
                            this.setPassive();
                        }
                    }

                    @Override
                    public ESat isEntailed() {
                        return ESat.TRUE;
                    }
                }));
            } else {
                solver.post(new Constraint("reif(a=b,r)", new Propagator<IntVar>(new IntVar[]{a, b, r}, PropagatorPriority.TERNARY, false){

                    @Override
                    public void propagate(int evtmask) throws ContradictionException {
                        if (r.getLB() == 1) {
                            if (((IntVar[])this.vars)[0].isInstantiated()) {
                                this.setPassive();
                                ((IntVar[])this.vars)[1].instantiateTo(((IntVar[])this.vars)[0].getValue(), this.aCause);
                            } else if (((IntVar[])this.vars)[1].isInstantiated()) {
                                this.setPassive();
                                ((IntVar[])this.vars)[0].instantiateTo(((IntVar[])this.vars)[1].getValue(), this.aCause);
                            }
                        } else if (r.getUB() == 0) {
                            if (((IntVar[])this.vars)[0].isInstantiated()) {
                                if (((IntVar[])this.vars)[1].removeValue(((IntVar[])this.vars)[0].getValue(), this.aCause)) {
                                    this.setPassive();
                                }
                            } else if (((IntVar[])this.vars)[1].isInstantiated() && ((IntVar[])this.vars)[0].removeValue(((IntVar[])this.vars)[1].getValue(), this.aCause)) {
                                this.setPassive();
                            }
                        } else if (((IntVar[])this.vars)[0].isInstantiated()) {
                            if (((IntVar[])this.vars)[1].isInstantiated()) {
                                if (((IntVar[])this.vars)[0].getValue() == ((IntVar[])this.vars)[1].getValue()) {
                                    r.setToTrue(this.aCause);
                                } else {
                                    r.setToFalse(this.aCause);
                                }
                                this.setPassive();
                            } else if (!((IntVar[])this.vars)[1].contains(((IntVar[])this.vars)[0].getValue())) {
                                this.setPassive();
                                r.setToFalse(this.aCause);
                            }
                        } else if (((IntVar[])this.vars)[1].isInstantiated()) {
                            if (!((IntVar[])this.vars)[0].contains(((IntVar[])this.vars)[1].getValue())) {
                                this.setPassive();
                                r.setToFalse(this.aCause);
                            }
                        } else if (((IntVar[])this.vars)[0].getLB() > ((IntVar[])this.vars)[1].getUB() || ((IntVar[])this.vars)[1].getLB() > ((IntVar[])this.vars)[0].getUB()) {
                            this.setPassive();
                            r.setToFalse(this.aCause);
                        }
                    }

                    @Override
                    public ESat isEntailed() {
                        throw new UnsupportedOperationException("isEntailed not implemented ");
                    }
                }));
            }
        } else {
            ICF.arithm(a, "=", b).reifyWith(r);
        }
    }
}

