/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.constraints;

import java.util.List;
import org.chocosolver.parser.flatzinc.FznSettings;
import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.parser.flatzinc.ast.constraints.IBuilder;
import org.chocosolver.parser.flatzinc.ast.expression.EAnnotation;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.sum.Scalar;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.StringUtils;

public class IntLinLeReifBuilder
implements IBuilder {
    @Override
    public void build(Solver solver, String name, List<Expression> exps, List<EAnnotation> annotations, Datas datas) {
        int[] as = exps.get(0).toIntArray();
        IntVar[] bs = exps.get(1).toIntVarArray(solver);
        IntVar c = exps.get(2).intVarValue(solver);
        BoolVar r = exps.get(3).boolVarValue(solver);
        if (bs.length > 0) {
            if (((FznSettings)solver.getSettings()).adhocReification() && c.isInstantiatedTo(0)) {
                int n = bs.length;
                boolean boolSum = c.isBool();
                for (int i = 0; i < n; ++i) {
                    boolSum &= bs[i].isBool();
                    boolSum &= as[i] == 1;
                }
                if (boolSum) {
                    BoolVar[] bbs = new BoolVar[n + 1];
                    for (int i = 0; i < n; ++i) {
                        bbs[i] = (BoolVar)bs[i];
                    }
                    bbs[bs.length] = r;
                    solver.post(new Constraint("BoolSumLeq0Reif", new PropBoolSumLeq0Reif(bbs)));
                    return;
                }
            } else if (c.isInstantiated()) {
                if (bs.length == 1) {
                    if (as[0] == -1) {
                        ICF.arithm(bs[0], ">=", -c.getValue()).reifyWith(r);
                        return;
                    }
                    if (as[0] == 1) {
                        ICF.arithm(bs[0], "<=", c.getValue()).reifyWith(r);
                        return;
                    }
                }
                if (bs.length == 2) {
                    if (as[0] == -1 && as[1] == 1) {
                        ICF.arithm(bs[1], "<=", bs[0], "+", c.getValue()).reifyWith(r);
                        return;
                    }
                    if (as[0] == 1 && as[1] == -1) {
                        ICF.arithm(bs[0], "<=", bs[1], "+", c.getValue()).reifyWith(r);
                        return;
                    }
                }
            }
            int[] tmp = Scalar.getScalarBounds(bs, as);
            IntVar scal = VF.bounded(StringUtils.randomName(), tmp[0], tmp[1], solver);
            Constraint cstr = ICF.scalar(bs, as, "=", scal);
            ICF.arithm(scal, "<=", c).reifyWith(r);
            solver.post(cstr);
        }
    }

    private static class PropBoolSumLeq0Reif
    extends Propagator<BoolVar> {
        public PropBoolSumLeq0Reif(BoolVar ... vs) {
            super((Variable[])vs);
        }

        @Override
        public void propagate(int evtmask) throws ContradictionException {
            int n = ((BoolVar[])this.vars).length - 1;
            if (((BoolVar[])this.vars)[n].getLB() == 1) {
                for (int i = 0; i < n; ++i) {
                    ((BoolVar[])this.vars)[i].setToFalse(this.aCause);
                }
                this.setPassive();
                return;
            }
            int firstOne = -1;
            int secondOne = -1;
            for (int i = 0; i < n; ++i) {
                if (((BoolVar[])this.vars)[i].getLB() == 1) {
                    ((BoolVar[])this.vars)[n].setToFalse(this.aCause);
                    this.setPassive();
                    return;
                }
                if (((BoolVar[])this.vars)[i].getUB() != 1) continue;
                if (firstOne == -1) {
                    firstOne = i;
                    continue;
                }
                if (secondOne != -1) continue;
                secondOne = i;
            }
            if (firstOne == -1) {
                ((BoolVar[])this.vars)[n].setToTrue(this.aCause);
                this.setPassive();
            } else if (secondOne == -1 && ((BoolVar[])this.vars)[n].getUB() == 0) {
                ((BoolVar[])this.vars)[firstOne].setToTrue(this.aCause);
            }
        }

        @Override
        public ESat isEntailed() {
            return ESat.TRUE;
        }
    }
}

