/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.constraints;

import java.util.List;
import org.chocosolver.parser.flatzinc.FznSettings;
import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.parser.flatzinc.ast.constraints.IBuilder;
import org.chocosolver.parser.flatzinc.ast.expression.EAnnotation;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.SatFactory;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

public class IntLtReifBuilder
implements IBuilder {
    @Override
    public void build(Solver solver, String name, List<Expression> exps, List<EAnnotation> annotations, Datas datas) {
        IntVar a = exps.get(0).intVarValue(solver);
        IntVar b = exps.get(1).intVarValue(solver);
        final BoolVar r = exps.get(2).boolVarValue(solver);
        if (((FznSettings)solver.getSettings()).enableClause() && (a.getTypeAndKind() & 0xF8) == 24 && (b.getTypeAndKind() & 0xF8) == 24) {
            SatFactory.addBoolIsLtVar((BoolVar)a, (BoolVar)b, r);
        } else if (((FznSettings)solver.getSettings()).adhocReification()) {
            if (a.isInstantiated() || b.isInstantiated()) {
                if (a.isInstantiated()) {
                    final IntVar var = b;
                    final int cste = a.getValue();
                    solver.post(new Constraint("reif(b>cste,r)", new Propagator<IntVar>(new IntVar[]{var, r}, PropagatorPriority.BINARY, false){

                        @Override
                        public void propagate(int evtmask) throws ContradictionException {
                            if (r.getLB() == 1) {
                                this.setPassive();
                                var.updateLowerBound(cste + 1, this.aCause);
                            } else if (r.getUB() == 0) {
                                if (var.updateUpperBound(cste, this.aCause)) {
                                    this.setPassive();
                                }
                            } else if (var.getLB() > cste) {
                                this.setPassive();
                                r.setToTrue(this.aCause);
                            } else if (var.getUB() <= cste) {
                                this.setPassive();
                                r.setToFalse(this.aCause);
                            }
                        }

                        @Override
                        public ESat isEntailed() {
                            return ESat.TRUE;
                        }
                    }));
                } else {
                    final IntVar var = a;
                    final int cste = b.getValue();
                    solver.post(new Constraint("reif(a<cste,r)", new Propagator<IntVar>(new IntVar[]{var, r}, PropagatorPriority.BINARY, false){

                        @Override
                        public void propagate(int evtmask) throws ContradictionException {
                            if (r.getLB() == 1) {
                                this.setPassive();
                                var.updateUpperBound(cste - 1, this.aCause);
                            } else if (r.getUB() == 0) {
                                if (var.updateLowerBound(cste, this.aCause)) {
                                    this.setPassive();
                                }
                            } else if (var.getUB() < cste) {
                                this.setPassive();
                                r.setToTrue(this.aCause);
                            } else if (var.getLB() >= cste) {
                                this.setPassive();
                                r.setToFalse(this.aCause);
                            }
                        }

                        @Override
                        public ESat isEntailed() {
                            throw new UnsupportedOperationException("isEntailed not implemented ");
                        }
                    }));
                }
            } else {
                solver.post(new Constraint("reif(a<b,r)", new Propagator<IntVar>(new IntVar[]{a, b, r}, PropagatorPriority.TERNARY, false){

                    @Override
                    public void propagate(int evtmask) throws ContradictionException {
                        if (r.getLB() == 1) {
                            ((IntVar[])this.vars)[0].updateUpperBound(((IntVar[])this.vars)[1].getUB() - 1, this.aCause);
                            ((IntVar[])this.vars)[1].updateLowerBound(((IntVar[])this.vars)[0].getLB() + 1, this.aCause);
                            if (((IntVar[])this.vars)[0].getUB() < ((IntVar[])this.vars)[1].getLB()) {
                                this.setPassive();
                            }
                        } else if (r.getUB() == 0) {
                            ((IntVar[])this.vars)[0].updateLowerBound(((IntVar[])this.vars)[1].getLB(), this.aCause);
                            ((IntVar[])this.vars)[1].updateUpperBound(((IntVar[])this.vars)[0].getUB(), this.aCause);
                            if (((IntVar[])this.vars)[0].getLB() >= ((IntVar[])this.vars)[1].getUB()) {
                                this.setPassive();
                            }
                        } else if (((IntVar[])this.vars)[0].getUB() < ((IntVar[])this.vars)[1].getLB()) {
                            this.setPassive();
                            r.setToTrue(this.aCause);
                        } else if (((IntVar[])this.vars)[0].getLB() >= ((IntVar[])this.vars)[1].getUB()) {
                            this.setPassive();
                            r.setToFalse(this.aCause);
                        }
                    }

                    @Override
                    public ESat isEntailed() {
                        return ESat.TRUE;
                    }
                }));
            }
        } else {
            ICF.arithm(a, "<", b).reifyWith(r);
        }
    }
}

