/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.constraints;

import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.List;
import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.parser.flatzinc.ast.constraints.IBuilder;
import org.chocosolver.parser.flatzinc.ast.expression.EAnnotation;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.SatFactory;
import org.chocosolver.solver.constraints.nary.cnf.LogOp;
import org.chocosolver.solver.constraints.set.SCF;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.util.tools.StringUtils;

public class SetLtBuilder
implements IBuilder {
    @Override
    public void build(Solver solver, String name, List<Expression> exps, List<EAnnotation> annotations, Datas datas) {
        SetVar a = exps.get(0).setVarValue(solver);
        SetVar b = exps.get(1).setVarValue(solver);
        SetVar ab = (SetVar)a.duplicate();
        SetVar ba = (SetVar)b.duplicate();
        TIntHashSet values = new TIntHashSet();
        int i = a.getEnvelopeFirst();
        while (i != Integer.MIN_VALUE) {
            values.add(i);
            i = a.getEnvelopeNext();
        }
        i = b.getEnvelopeFirst();
        while (i != Integer.MIN_VALUE) {
            values.add(i);
            i = b.getEnvelopeNext();
        }
        int[] env = values.toArray();
        Arrays.sort(env);
        SetVar c = VF.set(StringUtils.randomName(), env, solver);
        IntVar min = VF.integer(StringUtils.randomName(), env[0], env[env.length - 1], solver);
        BoolVar _b1 = SCF.subsetEq(new SetVar[]{a, b}).reif();
        BoolVar _b2 = SCF.all_different(new SetVar[]{a, b}).reif();
        solver.post(SCF.partition(new SetVar[]{ab, b}, a), SCF.partition(new SetVar[]{ba, a}, b), SCF.union(new SetVar[]{ab, ba}, c));
        SCF.min(c, min, false);
        BoolVar _b3 = SCF.member(min, a).reif();
        SatFactory.addClauses(LogOp.or(_b3, LogOp.and(_b1, _b2)), solver);
    }
}

