/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.constraints.global;

import java.util.List;
import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.parser.flatzinc.ast.constraints.IBuilder;
import org.chocosolver.parser.flatzinc.ast.expression.EAnnotation;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;

public class BinPackingBuilder
implements IBuilder {
    @Override
    public void build(Solver solver, String name, List<Expression> exps, List<EAnnotation> annotations, Datas datas) {
        int c = exps.get(0).intValue();
        IntVar[] item_bin = exps.get(1).toIntVarArray(solver);
        int[] item_size = exps.get(2).toIntArray();
        int min = 0x3FFFFFFF;
        int max = -1073741824;
        for (int i = 0; i < item_bin.length; ++i) {
            min = Math.min(min, item_bin[i].getLB());
            max = Math.max(max, item_bin[i].getUB());
        }
        IntVar[] loads = VF.boundedArray("TMPload", max - min + 1, 0, c, solver);
        solver.post(ICF.bin_packing(item_bin, item_size, loads, min));
    }
}

