/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.constraints.global;

import java.util.LinkedList;
import java.util.List;
import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.parser.flatzinc.ast.constraints.IBuilder;
import org.chocosolver.parser.flatzinc.ast.expression.EAnnotation;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;

public class BinPackingLoadBuilder
implements IBuilder {
    @Override
    public void build(Solver solver, String name, List<Expression> exps, List<EAnnotation> annotations, Datas datas) {
        IntVar[] loads = exps.get(0).toIntVarArray(solver);
        IntVar[] item_bin = exps.get(1).toIntVarArray(solver);
        int[] item_size = exps.get(2).toIntArray();
        LinkedList<Constraint> addCons = new LinkedList<Constraint>();
        for (int i = 0; i < item_bin.length; ++i) {
            if (item_bin[i].getLB() < 1) {
                addCons.add(ICF.arithm(item_bin[i], ">=", 1));
            }
            if (item_bin[i].getUB() <= loads.length) continue;
            addCons.add(ICF.arithm(item_bin[i], "<=", loads.length));
        }
        if (addCons.size() > 0) {
            solver.post(ArrayUtils.append(ICF.bin_packing(item_bin, item_size, loads, 1), (Constraint[])addCons.toArray()));
        } else {
            solver.post(ICF.bin_packing(item_bin, item_size, loads, 1));
        }
    }
}

