/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.constraints.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.parser.flatzinc.ast.constraints.IBuilder;
import org.chocosolver.parser.flatzinc.ast.expression.EAnnotation;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.IntConstraintFactory;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.variables.IntVar;

public class TableBuilder
implements IBuilder {
    @Override
    public void build(Solver solver, String name, List<Expression> exps, List<EAnnotation> annotations, Datas datas) {
        IntVar[] x = exps.get(0).toIntVarArray(solver);
        int[] f_t = exps.get(1).toIntArray();
        int d2 = x.length;
        int d1 = f_t.length / d2;
        ArrayList<int[]> t = new ArrayList<int[]>();
        for (int i = 0; i < d1; ++i) {
            t.add(Arrays.copyOfRange(f_t, i * d2, (i + 1) * d2));
        }
        Tuples tuples = new Tuples(true);
        for (int[] couple : t) {
            tuples.add(couple);
        }
        if (x.length == 2) {
            solver.post(ICF.table(x[0], x[1], tuples, "AC3bit+rm"));
        } else {
            solver.post(IntConstraintFactory.table(x, tuples, "GACSTR+"));
        }
    }
}

