/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.expression;

import java.util.Collections;
import java.util.List;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;

public final class EArray
extends Expression {
    public final List<Expression> what;

    public EArray(List<Expression> what) {
        super(Expression.EType.ARR);
        this.what = what;
    }

    public EArray() {
        super(Expression.EType.ARR);
        this.what = Collections.emptyList();
    }

    public Expression getWhat_i(int i) {
        return this.what.get(i);
    }

    public String toString() {
        StringBuilder st = new StringBuilder("[");
        st.append(this.what.get(0).toString());
        for (int i = 1; i < this.what.size(); ++i) {
            st.append(',').append(this.what.get(i).toString());
        }
        return st.append(']').toString();
    }

    @Override
    public int[] toIntArray() {
        int[] arr = new int[this.what.size()];
        for (int i = 0; i < this.what.size(); ++i) {
            arr[i] = this.what.get(i).intValue();
        }
        return arr;
    }

    @Override
    public boolean[] toBoolArray() {
        boolean[] arr = new boolean[this.what.size()];
        for (int i = 0; i < this.what.size(); ++i) {
            arr[i] = this.what.get(i).boolValue();
        }
        return arr;
    }

    @Override
    public BoolVar[] toBoolVarArray(Solver solver) {
        BoolVar[] arr = new BoolVar[this.what.size()];
        for (int i = 0; i < this.what.size(); ++i) {
            arr[i] = this.what.get(i).boolVarValue(solver);
        }
        return arr;
    }

    @Override
    public IntVar[] toIntVarArray(Solver solver) {
        IntVar[] arr = new IntVar[this.what.size()];
        for (int i = 0; i < this.what.size(); ++i) {
            arr[i] = this.what.get(i).intVarValue(solver);
        }
        return arr;
    }

    @Override
    public SetVar[] toSetVarArray(Solver solver) {
        SetVar[] arr = new SetVar[this.what.size()];
        for (int i = 0; i < this.what.size(); ++i) {
            arr[i] = this.what.get(i).setVarValue(solver);
        }
        return arr;
    }
}

