/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.expression;

import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VariableFactory;

public final class EBool
extends Expression {
    public final boolean value;
    public static final EBool instanceTrue = new EBool(true);
    public static final EBool instanceFalse = new EBool(false);

    public static EBool make(boolean value) {
        if (value) {
            return instanceTrue;
        }
        return instanceFalse;
    }

    private EBool(boolean value) {
        super(Expression.EType.BOO);
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int intValue() {
        return this.value ? 1 : 0;
    }

    @Override
    public int[] toIntArray() {
        return new int[]{this.intValue()};
    }

    @Override
    public boolean boolValue() {
        return this.value;
    }

    @Override
    public boolean[] toBoolArray() {
        return new boolean[]{this.boolValue()};
    }

    @Override
    public BoolVar boolVarValue(Solver solver) {
        return this.intValue() == 1 ? solver.ONE : solver.ZERO;
    }

    @Override
    public BoolVar[] toBoolVarArray(Solver solver) {
        return new BoolVar[]{this.boolVarValue(solver)};
    }

    @Override
    public IntVar intVarValue(Solver solver) {
        return VariableFactory.fixed(this.intValue(), solver);
    }

    @Override
    public IntVar[] toIntVarArray(Solver solver) {
        return new IntVar[]{this.intVarValue(solver)};
    }
}

