/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.expression;

import org.chocosolver.parser.flatzinc.ast.Datas;
import org.chocosolver.parser.flatzinc.ast.Exit;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.VariableFactory;

public final class EIdArray
extends Expression {
    public final String name;
    public final int index;
    final Object object;

    public EIdArray(Datas datas, String id, int i) {
        super(Expression.EType.IDA);
        this.name = id;
        this.index = i;
        Object array = datas.get(this.name);
        this.object = int_arr.isInstance(array) ? Integer.valueOf(((int[])array)[this.index - 1]) : (bool_arr.isInstance(array) ? Integer.valueOf(((boolean[])array)[this.index - 1] ? 1 : 0) : ((Object[])array)[this.index - 1]);
    }

    public String toString() {
        return this.name + '[' + this.index + ']';
    }

    @Override
    public int intValue() {
        return (Integer)this.object;
    }

    @Override
    public int[] toIntArray() {
        return (int[])this.object;
    }

    @Override
    public boolean boolValue() {
        return (Boolean)this.object;
    }

    @Override
    public boolean[] toBoolArray() {
        return (boolean[])this.object;
    }

    @Override
    public BoolVar boolVarValue(Solver solver) {
        if (Integer.class.isInstance(this.object)) {
            return (Integer)this.object == 1 ? solver.ONE : solver.ZERO;
        }
        if (Boolean.class.isInstance(this.object)) {
            return (Boolean)this.object != false ? solver.ONE : solver.ZERO;
        }
        return (BoolVar)this.object;
    }

    @Override
    public BoolVar[] toBoolVarArray(Solver solver) {
        if (this.object.getClass().isArray()) {
            if (int_arr.isInstance(this.object)) {
                int[] values = (int[])this.object;
                BoolVar[] vars = new BoolVar[values.length];
                for (int i = 0; i < values.length; ++i) {
                    vars[i] = (Integer)this.object == 1 ? solver.ONE : solver.ZERO;
                }
                return vars;
            }
            if (bool_arr.isInstance(this.object)) {
                int[] values = EIdArray.bools_to_ints((boolean[])this.object);
                BoolVar[] vars = new BoolVar[values.length];
                for (int i = 0; i < values.length; ++i) {
                    vars[i] = (Boolean)this.object != false ? solver.ONE : solver.ZERO;
                }
                return vars;
            }
            return (BoolVar[])this.object;
        }
        Exit.log();
        return null;
    }

    @Override
    public IntVar intVarValue(Solver solver) {
        if (Integer.class.isInstance(this.object)) {
            return VariableFactory.fixed((Integer)this.object, solver);
        }
        if (Boolean.class.isInstance(this.object)) {
            return VariableFactory.fixed((Boolean)this.object != false ? 1 : 0, solver);
        }
        return (IntVar)this.object;
    }

    @Override
    public IntVar[] toIntVarArray(Solver solver) {
        if (this.object.getClass().isArray()) {
            if (int_arr.isInstance(this.object)) {
                int[] values = (int[])this.object;
                IntVar[] vars = new IntVar[values.length];
                for (int i = 0; i < values.length; ++i) {
                    vars[i] = VariableFactory.fixed(values[i], solver);
                }
                return vars;
            }
            if (bool_arr.isInstance(this.object)) {
                int[] values = EIdArray.bools_to_ints((boolean[])this.object);
                IntVar[] vars = new IntVar[values.length];
                for (int i = 0; i < values.length; ++i) {
                    vars[i] = VariableFactory.fixed(values[i], solver);
                }
                return vars;
            }
            return (IntVar[])this.object;
        }
        Exit.log();
        return null;
    }

    @Override
    public SetVar setVarValue(Solver solver) {
        return (SetVar)this.object;
    }

    @Override
    public SetVar[] toSetVarArray(Solver solver) {
        if (this.object.getClass().isArray()) {
            return (SetVar[])this.object;
        }
        Exit.log();
        return null;
    }

    private static int[] bools_to_ints(boolean[] bar) {
        int[] values = new int[bar.length];
        for (int i = 0; i < bar.length; ++i) {
            values[i] = bar[i] ? 1 : 0;
        }
        return values;
    }
}

