/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.expression;

import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VariableFactory;

public final class EInt
extends Expression {
    public final int value;
    private static EInt[] cache = new EInt[256];
    static final int low = -128;
    static final int high = 127;

    public static EInt make(String svalue) {
        int value = Integer.parseInt(svalue);
        return EInt.make(value);
    }

    public static EInt make(int value) {
        if (value >= -128 && value <= 127) {
            return cache[value + 128];
        }
        return new EInt(value);
    }

    private EInt(int value) {
        super(Expression.EType.INT);
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public int[] toIntArray() {
        return new int[]{this.intValue()};
    }

    @Override
    public IntVar intVarValue(Solver solver) {
        return VariableFactory.fixed(this.intValue(), solver);
    }

    @Override
    public IntVar[] toIntVarArray(Solver solver) {
        return new IntVar[]{this.intVarValue(solver)};
    }

    static {
        int j = -128;
        for (int k = 0; k < cache.length; ++k) {
            EInt.cache[k] = new EInt(j++);
        }
    }
}

