/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.searches;

import org.chocosolver.parser.flatzinc.ast.searches.Assignment;
import org.chocosolver.parser.flatzinc.ast.searches.VarChoice;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.selectors.IntValueSelector;
import org.chocosolver.solver.search.strategy.selectors.VariableSelector;
import org.chocosolver.solver.search.strategy.selectors.VariableSelectorWithTies;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMax;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMedian;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMiddle;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMin;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainRandom;
import org.chocosolver.solver.search.strategy.selectors.variables.ActivityBased;
import org.chocosolver.solver.search.strategy.selectors.variables.AntiFirstFail;
import org.chocosolver.solver.search.strategy.selectors.variables.FirstFail;
import org.chocosolver.solver.search.strategy.selectors.variables.InputOrder;
import org.chocosolver.solver.search.strategy.selectors.variables.Largest;
import org.chocosolver.solver.search.strategy.selectors.variables.MaxRegret;
import org.chocosolver.solver.search.strategy.selectors.variables.Occurrence;
import org.chocosolver.solver.search.strategy.selectors.variables.Smallest;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.IntStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.slf4j.LoggerFactory;

public class IntSearch {
    private static long seed = 29091981L;

    private IntSearch() {
    }

    public static AbstractStrategy build(IntVar[] variables, VarChoice varChoice, Assignment assignment, Solver solver) {
        VariableSelector<IntVar> varsel = IntSearch.variableSelector(varChoice);
        if (varsel == null) {
            return new ActivityBased(solver, variables, 0.999, 0.02, 8, 2.0, 1, seed);
        }
        return IntSearch.valueSelector(variables, varsel, assignment);
    }

    private static VariableSelector<IntVar> variableSelector(VarChoice varChoice) {
        switch (varChoice) {
            case input_order: {
                return new InputOrder<IntVar>();
            }
            case first_fail: {
                return new FirstFail();
            }
            case anti_first_fail: {
                return new AntiFirstFail();
            }
            case smallest: {
                return new Smallest();
            }
            case largest: {
                return new Largest();
            }
            case occurrence: {
                return new Occurrence<IntVar>();
            }
            case most_constrained: {
                return new VariableSelectorWithTies<IntVar>(new Smallest(), new Occurrence());
            }
            case max_regret: {
                return new MaxRegret();
            }
        }
        LoggerFactory.getLogger(IntSearch.class).error("% No implementation for " + varChoice.name() + ". Set default.");
        return null;
    }

    private static IntStrategy valueSelector(IntVar[] scope, VariableSelector<IntVar> variableSelector, Assignment assignmennt) {
        IntValueSelector valSelector;
        DecisionOperator<IntVar> assgnt = DecisionOperator.int_eq;
        switch (assignmennt) {
            case indomain: 
            case indomain_min: {
                valSelector = new IntDomainMin();
                break;
            }
            case indomain_max: {
                valSelector = new IntDomainMax();
                break;
            }
            case indomain_middle: {
                valSelector = new IntDomainMiddle();
                break;
            }
            case indomain_median: {
                valSelector = new IntDomainMedian();
                break;
            }
            case indomain_random: {
                valSelector = new IntDomainRandom(seed);
                break;
            }
            case indomain_split: 
            case indomain_interval: {
                valSelector = new IntDomainMiddle(true);
                assgnt = DecisionOperator.int_split;
                break;
            }
            case indomain_reverse_split: {
                valSelector = new IntDomainMiddle(false);
                assgnt = DecisionOperator.int_reverse_split;
                break;
            }
            default: {
                LoggerFactory.getLogger(IntSearch.class).error("% No implementation for " + assignmennt.name() + ". Set default.");
                valSelector = new IntDomainMin();
            }
        }
        return new IntStrategy(scope, variableSelector, valSelector, assgnt);
    }
}

