/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.ast.searches;

import org.chocosolver.parser.flatzinc.ast.searches.Assignment;
import org.chocosolver.parser.flatzinc.ast.searches.VarChoice;
import org.chocosolver.solver.search.strategy.selectors.VariableSelector;
import org.chocosolver.solver.search.strategy.selectors.values.SetDomainMin;
import org.chocosolver.solver.search.strategy.selectors.variables.InputOrder;
import org.chocosolver.solver.search.strategy.selectors.variables.Occurrence;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.SetStrategy;
import org.chocosolver.solver.variables.SetVar;
import org.slf4j.LoggerFactory;

public class SetSearch {
    private SetSearch() {
    }

    public static AbstractStrategy build(SetVar[] variables, VarChoice varChoice, Assignment assignment) {
        VariableSelector<SetVar> varsel = SetSearch.variableSelector(varChoice);
        if (varsel == null) {
            LoggerFactory.getLogger("solver").error("% No free search defined for SetVar");
            return null;
        }
        return SetSearch.valueSelector(variables, varsel, assignment);
    }

    private static VariableSelector<SetVar> variableSelector(VarChoice varChoice) {
        switch (varChoice) {
            case input_order: {
                return new InputOrder<SetVar>();
            }
            case occurrence: {
                return new Occurrence<SetVar>();
            }
        }
        LoggerFactory.getLogger(SetSearch.class).warn("% No implementation for " + varChoice.name() + ". Set default.");
        return new InputOrder<SetVar>();
    }

    private static SetStrategy valueSelector(SetVar[] scope, VariableSelector<SetVar> variableSelector, Assignment assignment) {
        SetDomainMin valSelector;
        switch (assignment) {
            case indomain: 
            case indomain_min: {
                valSelector = new SetDomainMin();
                break;
            }
            default: {
                LoggerFactory.getLogger(SetSearch.class).warn("% No implementation for " + assignment.name() + ". Set default.");
                valSelector = new SetDomainMin();
            }
        }
        return new SetStrategy(scope, variableSelector, valSelector, true);
    }
}

