/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.layout;

import java.util.ArrayList;
import java.util.List;
import org.chocosolver.parser.flatzinc.ast.Exit;
import org.chocosolver.parser.flatzinc.ast.declaration.DArray;
import org.chocosolver.parser.flatzinc.ast.declaration.Declaration;
import org.chocosolver.parser.flatzinc.ast.expression.EArray;
import org.chocosolver.parser.flatzinc.ast.expression.ESetBounds;
import org.chocosolver.parser.flatzinc.ast.expression.ESetList;
import org.chocosolver.parser.flatzinc.ast.expression.Expression;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.solution.LastSolutionRecorder;
import org.chocosolver.solver.search.solution.Solution;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FZNLayout
implements IMonitorSolution,
IMonitorClose {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FZNLayout.class);
    List<String> output_names;
    List<Declaration.DType> output_types;
    List<Variable> output_vars;
    List<String> output_arrays_names;
    List<Declaration.DType> output_arrays_types;
    List<Variable[]> output_arrays_vars;
    StringBuilder stringBuilder = new StringBuilder();
    Solver solver;
    boolean wrongSolution;
    int nbSolution;
    boolean userinterruption = true;
    boolean printAll;
    protected final String instance;
    private Thread statOnKill;

    public FZNLayout(String instance, boolean printAll) {
        this.printAll = printAll;
        this.output_vars = new ArrayList<Variable>();
        this.output_names = new ArrayList<String>();
        this.output_types = new ArrayList<Declaration.DType>();
        this.output_arrays_names = new ArrayList<String>();
        this.output_arrays_vars = new ArrayList<Variable[]>();
        this.output_arrays_types = new ArrayList<Declaration.DType>();
        this.instance = instance;
    }

    @Override
    public void onSolution() {
        if (this.check()) {
            this.wrongSolution = false;
            ++this.nbSolution;
            if (this.printAll) {
                this.printSolution();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("% " + this.solver.getMeasures().toOneShortLineString());
                }
            }
        } else {
            System.err.println("%\n% /!\\ ERROR >>>>>>>   Find a solution that does not seem to be correct!!  <<<<<<<<\n%");
            System.exit(-200);
        }
    }

    private void printSolution() {
        int i;
        for (i = 0; i < this.output_names.size(); ++i) {
            System.out.printf("%s = %s;\n", this.output_names.get(i), this.value(this.output_vars.get(i), this.output_types.get(i)));
        }
        for (i = 0; i < this.output_arrays_names.size(); ++i) {
            String name = this.output_arrays_names.get(i);
            Variable[] ivars = this.output_arrays_vars.get(i);
            if (ivars.length > 0) {
                Declaration.DType type = this.output_arrays_types.get(i);
                this.stringBuilder.append(this.value(ivars[0], type));
                for (int j = 1; j < ivars.length; ++j) {
                    this.stringBuilder.append(", ").append(this.value(ivars[j], type));
                }
                System.out.printf(name, this.stringBuilder.toString());
                this.stringBuilder.setLength(0);
                continue;
            }
            System.out.printf(name, new Object[0]);
        }
        System.out.printf("----------\n", new Object[0]);
    }

    private boolean check() {
        return true;
    }

    private String value(Variable var, Declaration.DType type) {
        switch (type) {
            case BOOL: {
                return ((BoolVar)var).getValue() == 1 ? "true" : "false";
            }
            case INT: 
            case INT2: 
            case INTN: {
                return Integer.toString(((IntVar)var).getValue());
            }
            case SET: {
                StringBuilder st = new StringBuilder();
                st.append('{');
                for (int i : ((SetVar)var).getValues()) {
                    st.append(i).append(',');
                }
                if (st.length() > 1) {
                    st.deleteCharAt(st.length() - 1);
                }
                st.append('}');
                return st.toString();
            }
        }
        Exit.log();
        return "";
    }

    @Override
    public void beforeClose() {
        this.finalOutPut();
        if (this.statOnKill != null) {
            Runtime.getRuntime().removeShutdownHook(this.statOnKill);
        }
    }

    public void finalOutPut() {
        this.userinterruption = false;
        if (this.solver.getMeasures().getSolutionCount() == 0L) {
            if (this.wrongSolution && this.nbSolution == 0 || this.solver.hasReachedLimit()) {
                System.out.printf("=====UNKNOWN=====\n", new Object[0]);
            } else {
                System.out.printf("=====UNSATISFIABLE=====\n", new Object[0]);
            }
        } else {
            if (!this.printAll) {
                try {
                    this.solver.getSolutionRecorder().getLastSolution().restore();
                }
                catch (ContradictionException e) {
                    e.printStackTrace();
                }
                this.printSolution();
            }
            if (this.solver.hasReachedLimit() && this.solver.getObjectiveManager().isOptimization()) {
                System.out.printf("=====UNBOUNDED=====\n", new Object[0]);
            } else {
                System.out.printf("==========\n", new Object[0]);
            }
        }
        if (!LOGGER.isDebugEnabled()) {
            System.out.printf("%% " + this.solver.getMeasures().toOneShortLineString(), new Object[0]);
        } else {
            LOGGER.debug("%% - Search statistics");
            LOGGER.debug("%% \t Solutions : {}", (Object)this.solver.getMeasures().getSolutionCount());
            if (this.solver.getMeasures().hasObjective()) {
                LOGGER.debug("% \t Objective : {}", (Object)this.solver.getMeasures().getBestSolutionValue().intValue());
            }
            LOGGER.debug("%% \t Building time : {}ms", (Object)Float.valueOf(this.solver.getMeasures().getReadingTimeCount()));
            LOGGER.debug("%% \t Initial propagation : {}ms", (Object)Float.valueOf(this.solver.getMeasures().getInitialPropagationTimeCount()));
            LOGGER.debug("%% \t Resolution : {}ms", (Object)Float.valueOf(this.solver.getMeasures().getTimeCount()));
            LOGGER.debug("%% \t Nodes : {}", (Object)this.solver.getMeasures().getNodeCount());
            LOGGER.debug("%% \t Backtracks : {}", (Object)this.solver.getMeasures().getBackTrackCount());
            LOGGER.debug("%% \t Fails : {}", (Object)this.solver.getMeasures().getFailCount());
            LOGGER.debug("%% \t Restarts : {}", (Object)this.solver.getMeasures().getRestartCount());
            LOGGER.debug("%% \t Max Depth : {}", (Object)this.solver.getMeasures().getMaxDepth());
            LOGGER.debug("%% \t Memory : {}", (Object)this.solver.getMeasures().getUsedMemory());
            LOGGER.debug("%% \t Variables : {}", (Object)this.solver.getVars().length);
            LOGGER.debug("%% \t Constraints : {}", (Object)this.solver.getCstrs().length);
            LOGGER.debug("%% \t Checks : {} + {}", (Object)this.solver.getMeasures().getEventsCount(), (Object)this.solver.getMeasures().getPropagationsCount());
        }
    }

    public boolean isUserinterruption() {
        return this.userinterruption;
    }

    @Override
    public void afterClose() {
    }

    public void addOutputVar(String name, Variable variable, Declaration type) {
        this.output_names.add(name);
        this.output_vars.add(variable);
        this.output_types.add(type.typeOf);
    }

    public void addOutputArrays(String name, Variable[] variables, List<Expression> indices, Declaration type) {
        EArray array = (EArray)indices.get(0);
        this.stringBuilder.append(name).append(" = array").append(array.what.size()).append("d(");
        this.build(this.stringBuilder, array.getWhat_i(0));
        for (int i = 1; i < array.what.size(); ++i) {
            this.stringBuilder.append(',');
            this.build(this.stringBuilder, array.getWhat_i(i));
        }
        if (variables.length > 0) {
            this.stringBuilder.append(",[%s]);");
        } else {
            this.stringBuilder.append(",[]);");
        }
        this.stringBuilder.append("\n");
        this.output_arrays_names.add(this.stringBuilder.toString());
        this.output_arrays_vars.add((Variable[])variables.clone());
        this.output_arrays_types.add(((DArray)type).getWhat().typeOf);
        this.stringBuilder.setLength(0);
    }

    private int[] build(StringBuilder st, Expression exp) {
        switch (exp.getTypeOf()) {
            case INT: {
                int idx = exp.intValue();
                st.append(idx);
                return new int[]{idx};
            }
            case SET_B: {
                ESetBounds esb = (ESetBounds)exp;
                st.append(esb.toString());
                return esb.enumVal();
            }
            case SET_L: {
                ESetList esl = (ESetList)exp;
                st.append(esl.toString());
                return esl.enumVal();
            }
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("output_array:: Unknown index {}", (Object)exp.getTypeOf());
        }
        return new int[0];
    }

    public void set(Solver solver) {
        solver.plugMonitor(this);
        this.solver = solver;
        if (!this.printAll) {
            solver.set(new LastSolutionRecorder(new Solution(), true, solver));
        }
        this.makeup();
    }

    public void makeup() {
        this.statOnKill = new Thread(){

            @Override
            public void run() {
                if (FZNLayout.this.isUserinterruption()) {
                    FZNLayout.this.finalOutPut();
                    System.out.printf("%% Unexpected resolution interruption!", new Object[0]);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.statOnKill);
    }
}

