/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.para;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.chocosolver.parser.flatzinc.Flatzinc;
import org.chocosolver.parser.flatzinc.FznSearchBinder;
import org.chocosolver.parser.flatzinc.FznSettings;
import org.chocosolver.parser.flatzinc.para.ParserSlave;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.objective.ObjectiveManager;
import org.chocosolver.solver.search.limits.FailCounter;
import org.chocosolver.solver.search.loop.lns.LNSFactory;
import org.chocosolver.solver.search.strategy.ISF;
import org.chocosolver.solver.thread.AbstractParallelMaster;
import org.chocosolver.solver.variables.IntVar;

public class ParserMaster
extends AbstractParallelMaster<ParserSlave> {
    int bestVal;
    int nbSol;
    boolean closeWithSuccess;
    ResolutionPolicy policy;
    Flatzinc aPas;
    ExecutorService executor;
    boolean alive = true;

    public ParserMaster(int nbCores, String[] args) {
        nbCores = Math.min(nbCores, 4);
        this.slaves = new ParserSlave[nbCores];
        for (int i = 0; i < nbCores; ++i) {
            ((ParserSlave[])this.slaves)[i] = new ParserSlave(this, i, args, new FznSettings());
            final ParserSlave slave = ((ParserSlave[])this.slaves)[i];
            if (i == 0) {
                this.aPas = slave.fznp;
            }
            Solver solver = slave.fznp.getSolver();
            final ObjectiveManager om = solver.getObjectiveManager();
            final IntVar[] dvars = slave.fznp.datas.getIntSearchVars();
            this.executor = Executors.newFixedThreadPool(nbCores);
            switch (i) {
                case 0: {
                    new FznSearchBinder(){

                        @Override
                        public void configureSearch(Solver solver) {
                            if (solver.getStrategy() == null) {
                                super.configureSearch(solver);
                            }
                            solver.set(ISF.lastConflict(solver));
                        }
                    }.configureSearch(solver);
                    break;
                }
                case 1: {
                    new FznSearchBinder(){

                        @Override
                        public void configureSearch(Solver solver) {
                            if (!om.isOptimization()) {
                                solver.set(ISF.domOverWDeg(dvars, 0L));
                            } else {
                                LNSFactory.pglns(solver, dvars, 200, 100, 10, 29091981L, new FailCounter(30L));
                            }
                            solver.set(ISF.lastConflict(solver));
                        }
                    }.configureSearch(solver);
                    break;
                }
                case 2: {
                    new FznSearchBinder(){

                        @Override
                        public void configureSearch(Solver solver) {
                            if (!om.isOptimization()) {
                                solver.set(ISF.domOverWDeg(dvars, 0L));
                            } else {
                                LNSFactory.rlns(solver, dvars, 200, 29091981L, new FailCounter(30L));
                            }
                            solver.set(ISF.lastConflict(solver));
                        }
                    }.configureSearch(solver);
                    break;
                }
            }
            Thread t = new Thread(){

                @Override
                public void run() {
                    slave.work();
                    ((ParserMaster)slave.master).wishGranted();
                }
            };
            this.executor.submit(t);
        }
    }

    @Override
    public synchronized void wishGranted() {
        System.out.printf("IN:%s\n", this.alive);
        if (this.alive) {
            this.alive = false;
            if (this.nbSol == 0) {
                if (!this.closeWithSuccess) {
                    System.out.println("=====UNKNOWN=====");
                } else {
                    System.out.println("=====UNSATISFIABLE=====");
                }
            } else if (!this.closeWithSuccess && this.policy != null && this.policy != ResolutionPolicy.SATISFACTION) {
                System.out.println("=====UNBOUNDED=====");
            } else {
                System.out.println("==========");
            }
            Number[] nbs = ((ParserSlave[])this.slaves)[0].solver.getMeasures().toArray();
            nbs[0] = this.nbSol;
            nbs[5] = this.policy != ResolutionPolicy.SATISFACTION ? this.bestVal : 0;
            for (int k = 0; k < ((ParserSlave[])this.slaves).length; ++k) {
                System.out.printf("Kill %d\n", k);
                ((ParserSlave[])this.slaves)[k].fznp.getSolver().getSearchLoop().interrupt("Master directive");
            }
            this.executor.shutdownNow();
        }
        System.exit(0);
    }

    public synchronized boolean newSol(int val, ResolutionPolicy policy) {
        this.policy = policy;
        if (this.nbSol == 0) {
            this.bestVal = val;
        }
        ++this.nbSol;
        boolean isBetter = false;
        switch (policy) {
            case MINIMIZE: {
                if (this.bestVal <= val && this.nbSol != 1) break;
                this.bestVal = val;
                isBetter = true;
                break;
            }
            case MAXIMIZE: {
                if (this.bestVal >= val && this.nbSol != 1) break;
                this.bestVal = val;
                isBetter = true;
                break;
            }
            case SATISFACTION: {
                this.bestVal = 1;
                boolean bl = isBetter = this.nbSol == 1;
            }
        }
        if (isBetter) {
            for (int i = 0; i < ((ParserSlave[])this.slaves).length; ++i) {
                if (((ParserSlave[])this.slaves)[i] == null) continue;
                ((ParserSlave[])this.slaves)[i].findBetterThan(val, policy);
            }
        }
        return isBetter;
    }

    public synchronized void closeWithSuccess() {
        this.closeWithSuccess = true;
    }
}

