/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.parser.flatzinc.para;

import java.io.IOException;
import org.chocosolver.parser.flatzinc.BaseFlatzincListener;
import org.chocosolver.parser.flatzinc.Flatzinc;
import org.chocosolver.parser.flatzinc.layout.FZNLayoutPara;
import org.chocosolver.parser.flatzinc.para.ParserMaster;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Settings;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.objective.ObjectiveManager;
import org.chocosolver.solver.thread.AbstractParallelSlave;

public class ParserSlave
extends AbstractParallelSlave<ParserMaster> {
    String[] args;
    Solver solver;
    Flatzinc fznp;

    public ParserSlave(final ParserMaster master, int id, String[] args, Settings settings) {
        super(master, id);
        this.args = args;
        this.fznp = new Flatzinc();
        try {
            this.fznp.parseParameters(args);
            this.fznp.addListener(new BaseFlatzincListener(this.fznp){

                @Override
                public void buildLayout(String instance, boolean printAll) {
                    FZNLayoutPara fl = new FZNLayoutPara(master, ParserSlave.this.fznp.instance, printAll);
                    ParserSlave.this.fznp.datas.setLayout(fl);
                    fl.set(ParserSlave.this.fznp.getSolver());
                }
            });
            this.fznp.defineSettings(settings);
            this.fznp.createSolver();
            this.fznp.parseInputFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void work() {
        this.solver = this.fznp.getSolver();
        this.fznp.configureSearch();
        this.fznp.solve();
        if (!this.solver.hasReachedLimit()) {
            ((ParserMaster)this.master).closeWithSuccess();
        }
    }

    public void findBetterThan(int val, ResolutionPolicy policy) {
        if (this.solver == null) {
            return;
        }
        ObjectiveManager iom = this.solver.getObjectiveManager();
        if (iom == null) {
            return;
        }
        switch (policy) {
            case MAXIMIZE: {
                iom.updateBestLB(val);
                break;
            }
            case MINIMIZE: {
                iom.updateBestUB(val);
                break;
            }
        }
    }
}

