/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.samples;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.explanations.ExplanationFactory;
import org.chocosolver.solver.trace.Chatterbox;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public abstract class AbstractProblem {
    @Option(name="-log", usage="Quiet resolution", required=false)
    protected Level level = Level.SOLUTION;
    @Option(name="-seed", usage="Seed for Shuffle propagation engine.", required=false)
    protected long seed = 29091981L;
    @Option(name="-ee", aliases={"--exp-eng"}, usage="Type of explanation engine to plug in")
    ExplanationFactory expeng = ExplanationFactory.NONE;
    @Option(name="-fe", aliases={"--flatten-expl"}, usage="Flatten explanations (automatically plug ExplanationFactory. NONE in if undefined).", required=false)
    protected boolean fexp = false;
    protected Solver solver;
    private boolean userInterruption = true;

    public void printDescription() {
    }

    public Solver getSolver() {
        return this.solver;
    }

    public abstract void createSolver();

    public abstract void buildModel();

    public abstract void configureSearch();

    public abstract void solve();

    public abstract void prettyOut();

    public final boolean readArgs(String ... args) {
        CmdLineParser parser = new CmdLineParser(this);
        parser.setUsageWidth(160);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java " + this.getClass() + " [options...]");
            parser.printUsage(System.err);
            System.err.println();
            return false;
        }
        return true;
    }

    protected void overrideExplanation() {
        if (!this.solver.getExplainer().isActive()) {
            this.expeng.plugin(this.solver, this.fexp);
        }
    }

    private boolean userInterruption() {
        return this.userInterruption;
    }

    public final void execute(String ... args) {
        if (this.readArgs(args)) {
            this.printDescription();
            this.createSolver();
            this.buildModel();
            this.configureSearch();
            this.overrideExplanation();
            if (this.level.getLevel() > Level.SILENT.getLevel()) {
                Chatterbox.showStatistics(this.solver);
                if (this.level.getLevel() > Level.VERBOSE.getLevel()) {
                    Chatterbox.showSolutions(this.solver);
                }
                if (this.level.getLevel() > Level.SOLUTION.getLevel()) {
                    Chatterbox.showDecisions(this.solver);
                }
            }
            Thread statOnKill = new Thread(){

                @Override
                public void run() {
                    if (AbstractProblem.this.userInterruption()) {
                        if (AbstractProblem.this.level.getLevel() > Level.SILENT.getLevel()) {
                            System.out.println(String.format("[STATISTICS {%s]", AbstractProblem.this.solver.getMeasures().toOneLineString()));
                        }
                        if (AbstractProblem.this.level.getLevel() > Level.SILENT.getLevel()) {
                            System.out.println("Unexpected resolution interruption!");
                        }
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(statOnKill);
            this.solve();
            if (this.level.getLevel() > Level.QUIET.getLevel()) {
                this.prettyOut();
            }
            this.userInterruption = false;
            Runtime.getRuntime().removeShutdownHook(statOnKill);
        }
    }

    public static enum Level {
        SILENT(-10),
        QUIET(0),
        VERBOSE(10),
        SOLUTION(20),
        SEARCH(30);

        int level;

        private Level(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

